<?php
/**
 * Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2025 vi-solutions
 * @since        Visforms 5.4.0
 */

namespace Visolutions\Component\Visforms\Administrator\Model\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Visolutions\Component\Visforms\Administrator\Helper\Pdf\PdfHelper;
use Visolutions\Component\Visforms\Site\Model\VisformsdataModel;

class ReplaceParameter {
	// framework
	private $app;
	private $input;
	private $user;
	// helper
	private $pdfHelper;
	// implementation
	private $form;
	private $fields;
	private $item;
	private $replaceParameter;
	private $itemAvailable;

	public function __construct() {
		// framework
		$this->app       = Factory::getApplication();
		$this->input     = $this->app->getInput();
		$this->user		 = $this->app->getIdentity();
		// helper
		$this->pdfHelper = new PdfHelper($this->input, $this->user);
	}

	public function initializeForDataDetail(string $context, string $parameter, MVCFactoryInterface $mvcFactory) : void {
		$supportedOptions       = array('com_visforms');
		$supportedViews         = array('visformsdata');

		// do we have to run?
		// make sure that blanks do not disrupt the format
		$this->replaceParameter = str_contains(str_replace(' ', '', $parameter), '"replace_parameter":"true"');
		if (!$this->replaceParameter) {
			return;
		}

		// get input parameter
		$option                 = $this->app->getInput()->get('option', '');
		$view                   = $this->app->getInput()->get('view', '');
		// input parameter 'id': may not be a form ID, might be anything
		$formID                 = $this->app->getInput()->getInt('id', -1);
		// in visforms data detail view: detail record id
		$cIDs                   = $this->app->getInput()->get('cid', array(), 'ARRAY');

		// check, if we are on a page that is created by a visforms data view menu item
        // data view or data view with edit link or detailitem
		$formAvailable          = (in_array($option, $supportedOptions) && in_array($view, $supportedViews));
		// check, if view is a visforms data detail view
		$this->itemAvailable    = !empty($cIDs) && $formAvailable;

		// if an ID of a visforms form is available: initialize the data model
		if ($formAvailable) {
			/* @var $model VisformsdataModel */
			$model        = $mvcFactory->createModel('Visformsdata', 'Site', ['context' => $context, 'formid' => $formID]);
			$this->form   = $model->getForm();
			// list of all published fields
			$this->fields = $model->getAllPublishedDataFields();
			// data record as stored in database
			$this->item   = ($this->itemAvailable ? $model->getFullDetail() : array());
		}
		return;
	}

	public function replaceParameter(string $text) : string {
		// do we have to run?
		if (!$this->replaceParameter) {
			return $text;
		}

		// framework objects: are always possible
		$text = $this->pdfHelper->processFrameworkObjects($text);

		// item: only if an item is available
		if($this->itemAvailable && !empty($this->item)) {
			$text = $this->pdfHelper->getReplacedText($this->item, $text, $this->form, $this->fields);
		}

		return $text;
	}
}