<?php
/**
 * Visfields view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace Visolutions\Component\Visforms\Administrator\View\Visfields;

defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\View\ItemsViewBase;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

class HtmlView extends ItemsViewBase
{
	function __construct($config = array()) {
        parent::__construct($config);
        $this->viewName = 'visfields';
        $this->editViewName = 'visfield';
        // filter field 'hassub' creates empty space; hide it completely
        if ($this->getLayout() !== 'modal') {
            $this->addCustomViewStyleCss('.js-stools-field-filter:first-child {display:none;}');
        }
    }

	protected function setMembers() {
        $fid            = Factory::getApplication()->getInput()->getInt('fid', 0);
        $this->canDo    = VisformsHelper::getActions($fid);
    }

    protected function getTitle() {
        return Text::_('COM_VISFORMS_FIELDS');
    }

    protected function setToolbar() {
        if ($this->fid === 0) {
            // no toolbar
            Factory::getApplication()->enqueueMessage(Text::_('COM_VISFORMS_ITEMS_VIEW_SELECT_FORM_FIRST_LABEL'));
        }
        else {
            parent::setItemsToolbar('COM_VISFORMS_DELETE_FIELD_TRUE');
        }
    }
}