<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class CalculationEntry extends VisfieldPlaceholderEntry {

    protected static $customParams = array();

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_CALCULATION_DIE_ZERO'
    );

    public function getReplaceValue() {
        $customParams = array_merge(self::$customParams, self::$customSubscriptionParams);
        // if data is empty string, replace the placeholder with nothing
        // this is the case for conditional calculation fields which are hidden
        if (isset($this->rawData) && ($this->rawData === '')) {
            if (!empty($this->param) && array_key_exists($this->param, $customParams) && ($this->param === 'DIE') && $this->hasSub) {
                return 'die';
            }
            return '';
        }

        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'DIE' :
                    if (VisformsHelper::checkNumberValueIsZero($this->rawData)) {
                        return 'die';
                    }
                    // return empty string to remove the placeholder
                    return '';
                default:
                    return $this->rawData;
            }
        }
        return $this->rawData;
    }
}