<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class CreatedEntry extends VisfieldPlaceholderEntry {

    protected static $customParams = array(
        'DATE' => 'COM_VISFORMS_PLACEHOLDER_PARAM_CREATED_DATE',
    );

    protected $createDate = false;

    public function __construct($param, $rawData, $field) {
        // call with $rawData = null, in order to get current date and time
        // set a flag in order to know that we have to create the date
        if (is_null($rawData)) {
            $this->createDate = true;
        }
        parent::__construct($param, $rawData, $field);
    }

    public function getReplaceValue() {
        $customParams = self::$customParams;
        $dateFormat = Text::_('DATE_FORMAT_LC6');
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'DATE' :
                    $dateFormat = Text::_('DATE_FORMAT_LC4');
            }
        }
        // call with $rawData = null, in order to get current date and time
        if ($this->createDate) {
            $this->rawData = VisformsHelper::getFormattedServerDateTime('now', $dateFormat);
        }
        else {
            $this->rawData = VisformsHelper::getFormattedServerDateTime($this->rawData, $dateFormat);
        }
        return $this->rawData;
    }
}