<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class LocationEntry extends VisfieldPlaceholderEntry {

	protected static $customParams = array (
		'LAT' => 'COM_VISFORMS_PLACEHOLDER_PARAM_LAT_ONLY',
		'LNG' => 'COM_VISFORMS_PLACEHOLDER_PARAM_LNG_ONLY'
	);

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_DIE'
    );

	public function getReplaceValue() {
        $customParams = array_merge(self::$customParams, self::$labelParams, self::$customSubscriptionParams);
        $values = array();
        if (is_string($this->rawData)) {
            $values = VisformsHelper::registryArrayFromString($this->rawData);
        }
        else if (is_array($this->rawData)) {
            $values = $this->rawData;
        }
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
			switch ($this->param) {
                case 'DISPLAYLABEL' :
                    return $this->field->label;
                case 'DISPLAYLABELPLUSSPACE' :
                    return $this->field->label . ' ';
				case 'LAT' :
					return $values['lat'] ?? '';
				case 'LNG' :
					return $values['lng'] ?? '';
                case 'DIE' :
                    if (empty($this->rawData) && $this->hasSub) {
                        return 'die';
                    }
                    if (empty($values['lat']) && empty($values['lng']) && $this->hasSub) {
                        return 'die';
                    }
                    // return empty string to remove the placeholder
                    return '';
				default:
					return '';
			}
		}
		return $this->rawData;
	}
}