<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\FileLayout;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class SignatureEntry extends VisfieldPlaceholderEntry {

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_DIE'
    );

	public function getReplaceValue() {
        if (isset($this->rawData) && ($this->rawData === '')) {
            if (!empty($this->param) && $this->param === 'DIE' && $this->hasSub) {
                return 'die';
            }
            return '';
        }
        $customParams =  array_merge(self::$labelParams, self::$customSubscriptionParams);
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'DISPLAYLABEL' :
                    return $this->field->label;
                case 'DISPLAYLABELPLUSSPACE' :
                    return $this->field->label . ' ';
                default:
                    return '';
            }
        }
        else {
            $field = $this->field;
            if (!isset($field->canvasWidth)) {
                $field->canvasWidth = isset($field['defaultvalue']['f_signature_canvasWidth']) ? (int)$field['defaultvalue']['v_signature_canvasWidth'] : 280;
            }
            if (!isset($field->canvasHeight)) {
                $field->canvasWidth = isset($field['defaultvalue']['f_signature_canvasHeight']) ? (int)$field['defaultvalue']['v_signature_canvasHeight'] : 120;
            }
            $layout = new FileLayout('visforms.datas.fields.signature', null);
            $layout->setOptions(array('component' => 'com_visforms'));
            return $layout->render(array('field' => $field, 'data' => $this->rawData, 'maxWidth' => 200));
        }
	}
}