<?php 
/**
 * Visfield field view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\FileLayout;

$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('form.validate');
$wa->useScript('keepalive');
$fieldsetsWithOptionlist = array('visf_select_options', 'visf_radio_options', 'visf_multicheckbox_options');
$token = Session::getFormToken();
$fntext = 'Joomla\CMS\Language\Text::_';
$fnroute = 'Joomla\CMS\Router\Route::_';

// using <<< is a bit tricky. Static functions like Text::_ cannot be called directly. Use either $this->escape(Text::_('TEXT)) or $fntext('TEXT', true)
// $this->escape does not return the desired result, if we have a string with quotes (See COM_VISFORMS_CHECKBOX_VALUE_REQUIRED)
// $fntext('TEXT', true) parameter "true" to ensure that text is escaped properly for js
$js = <<<JS
    jQuery(document).ready(function() {
        visHelperAsync.stopWaitDonut();
        visAdmin.visField.initPage();
    });
    Joomla.submitbutton = function(task) {
		if (task == 'visfield.cancel') {
            jQuery('#permissions-sliders select').attr('disabled', 'disabled');
            Joomla.submitform(task, document.getElementById('item-form'));
		}
		else if (document.formvalidator.isValid(document.getElementById('item-form'))) {
            Joomla.removeMessages();
            jQuery('#permissions-sliders select').attr('disabled', 'disabled');
            // remove fields which are already saved using ajax (class = visajax-submit)
            jQuery('.visajax-submit').attr('disabled', 'disabled');
            //make sure the typefield has a selected value
            var ft = document.getElementById('jform_typefield');
            var idx = ft.selectedIndex;
            var sel = ft[idx].value;
            switch (sel) {
                case '0' :
                    alert('{$this->escape(Text::_('COM_VISFORMS_TYPE_FIELD_REQUIRED'))}');
                    break;
                case 'checkbox' :
                    var cbval = document.getElementById('jform_defaultvalue_f_checkbox_attribute_value');
                    if (cbval.value == "") {
                        alert('{$fntext('COM_VISFORMS_CHECKBOX_VALUE_REQUIRED', true)}');
                    }
                    else {
                        visAdmin.visField.removeUnused(sel);
                        Joomla.submitform(task, document.getElementById('item-form'));
                    }
                    break;
                case 'multicheckbox' :
                case 'radio' :
                    jQuery('#jform_defaultvalue_f_' + sel + '_list_hidden').storeVisformsOptionCreatorData();
                    var grpel = document.getElementById('jform_defaultvalue_f_' + sel + '_list_hidden');
                    var countDefOpts = document.getElementById('jform_defaultvalue_f_' + sel + '_countDefaultOpts').value;
                    if (grpel.value == "" || grpel.value == "{}") {
                        alert('{$this->escape(Text::_('COM_VISFORMS_OPTIONS_REQUIRED'))}');
                    }
                    else if (countDefOpts > 1) {
                        alert('{$this->escape(Text::_('COM_VISFORMS_ONLY_ONE_DEFAULT_OPTION_POSSIBLE'))}');
                    }
                    else {
                        visAdmin.visField.removeUnused(sel);
                        Joomla.submitform(task, document.getElementById('item-form'));
                    }
                    break;
                case 'select' :
                    jQuery('#jform_defaultvalue_f_' + sel + '_list_hidden').storeVisformsOptionCreatorData();
                    var grpel = document.getElementById('jform_defaultvalue_f_' + sel + '_list_hidden');
                    var countDefOpts = document.getElementById('jform_defaultvalue_f_' + sel + '_countDefaultOpts').value;
                    var isMultiple = document.getElementById('jform_defaultvalue_f_' + sel + '_attribute_multiple').checked;
                    if (grpel.value == "" || grpel.value == "{}") {
                        alert('{$this->escape(Text::_('COM_VISFORMS_OPTIONS_REQUIRED'))}');
                    }
                    else if ((countDefOpts > 1) && (isMultiple == false)) {
                        alert('{$this->escape(Text::_('COM_VISFORMS_ONLY_ONE_DEFAULT_OPTION_POSSIBLE'))}');
                    }
                    else {
                        visAdmin.visField.removeUnused(sel);
                        Joomla.submitform(task, document.getElementById('item-form'));
                    }
                    break;
                case 'radiosql':
                case 'multicheckboxsql':
                case 'selectsql':
                    var sql = document.getElementById('jform_defaultvalue_f_' + sel + '_sql').value;
                    if (sql == "") {
                        alert('{$this->escape(Text::_('COM_VISFORMS_SQL_REQUIRED'))}');
                    }
                    else {
                        visAdmin.visField.removeUnused(sel);
                        Joomla.submitform(task, document.getElementById('item-form'));
                    }
                    break;
                case 'image':
                        var altt = document.getElementById('jform_defaultvalue_f_image_attribute_alt');
                        var image = document.getElementById('jform_defaultvalue_f_image_attribute_src');
                        if ((altt.value == "") || (image.value == "")) {
                            if (altt.value == "") {
                                alert('{$fntext('COM_VISFORMS_ALT_TEXT_REQUIRED', true)}');
                            }
                            else {
                                alert('{$this->escape(Text::_('COM_VISFORMS_FIELD_IMAGE_IMAGE_REQUIRED'))}');
                            }
                        }
                        else {
                            visAdmin.visField.removeUnused(sel);
                            Joomla.submitform(task, document.getElementById('item-form'));
                        }
                    break;
                case 'location' :
                    var reLat = /^[-]?(([0-8]?[0-9])\.(\d+))|(90(\.0+)?)$/;
                    var reLng = /^[-]?((((1[0-7][0-9])|([0-9]?[0-9]))\.(\d+))|180(\.0+)?)$/;
                    var latCenter = document.getElementById('jform_defaultvalue_f_location_defaultMapCenter_lat').value;
                    var lngCenter = document.getElementById('jform_defaultvalue_f_location_defaultMapCenter_lng').value;
                    var validLatCenter = reLat.test(latCenter) && latCenter !== "";
                    var validLngCenter = reLng.test(lngCenter) && lngCenter !== "";
                    var latPos = document.getElementById('jform_defaultvalue_f_location_attribute_value_lat').value;
                    var lngPos = document.getElementById('jform_defaultvalue_f_location_attribute_value_lng').value;
                    var validLatPos = (reLat.test(latPos) || (latPos === "" && lngPos === ""));
                    var validLngPos = (reLng.test(lngPos) || (latPos === "" && lngPos === ""));
                    if (!validLatCenter || !validLngCenter) {
                        alert('{$this->escape(Text::_('COM_VISFORMS_LOCATION_DEFAULT_CENTER_VALUES_REQUIRED'))}');
                    } else if (!validLatPos || !validLngPos) {
                        alert('{$this->escape(Text::_('COM_VISFORMS_LOCATION_DEFAULT_POSITION_VALUES_INVALID_FORMAT'))}');
                    }
                    else {
                        visAdmin.visField.removeUnused(sel);
                        Joomla.submitform(task, document.getElementById('item-form'));
                    }
                    break;
                case 'calculation':
                    var equation = document.getElementById('jform_defaultvalue_f_' + sel + '_equation').value;
                    if (equation == "") {
                        alert('{$this->escape(Text::_('COM_VISFORMS_EQUATION_REQUIRED'))}');
                    }
                    else {
                        visAdmin.visField.removeUnused(sel);
                        Joomla.submitform(task, document.getElementById('item-form'));
                    }
                    break;
                default :
                    visAdmin.visField.removeUnused(sel);
                    Joomla.submitform(task, document.getElementById('item-form'));
                    break;
            }
		}
	}
JS;
$wa->addInlineScript($js);

// get a list of all visFieldPlugin Tabs
$formFieldSets = $this->form->getFieldsets();
foreach ($formFieldSets as $name => $fieldSet) {
    if (!str_contains($name, 'visfield-extension') && empty($fieldSet->parent)) {
            unset($formFieldSets[$name]);
    }
}
$subFieldsetCounter = 0;
?>

<form action="<?php echo Route::_("$this->baseUrl&view=$this->editViewName&layout=edit&id=$this->id&fid=$this->fid"); ?>" method="post" name="adminForm" id="item-form" class="form-validate">
    <input type="hidden" name="option" value="com_visforms" />
    <input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
    <input type="hidden" name="fid" value="<?php echo $this->fid; ?>" />
    <input type="hidden" name="ordering" value="<?php echo $this->item->ordering; ?>" />
    <input type="hidden" name="controller" value="visfields" /><?php
    $layout = new FileLayout('div.form_hidden_inputs');
    echo $layout->render(); ?>
	<div class="j-main-container">
        <div class="m-t-2 m-b-3"><?php
            echo $this->form->renderField('label');
            echo $this->form->renderField('name'); ?>
        </div>
        <div class="form-horizontal"><?php
            echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'basicfieldinfo', 'recall' => true, 'breakpoint' => 768));
            echo HTMLHelper::_('uitab.addTab', 'myTab', 'basicfieldinfo', Text::_('COM_VISFORMS_FIELD_BASIC_INFO')); ?>
            <div class="row">
                <div class="col-12"><?php
                    echo '<h3 class="pb-4">' .  Text::_('COM_VISFORMS_GENERAL_SETTINGS').'</h3>';?>
                    <div class="row">
                    <div class="col-lg-12 col-xl-6"><?php
                        echo $this->form->renderField('published');
                        echo $this->form->renderField('created');
                        echo $this->form->renderField('created_by');
                        echo $this->form->renderField('typefield');?>
                    </div>
                    <div class="col-lg-12 col-xl-6">
                        <div class="row"><?php
                        echo $this->form->renderField('id');
                        echo $this->form->renderField('fid');
                        echo $this->form->renderField('formtitle');
                        echo $this->form->renderField('fordering');
                        echo $this->form->renderField('fdataordering');
                    ?></div></div>
                </div>
                <div class="col-12"><?php
                    $groupFieldSets = $this->form->getFieldsets('defaultvalue');
                    foreach ($groupFieldSets as $name => $fieldSet) {
                        if (in_array($name, $fieldsetsWithOptionlist)) {continue;}?>
                        <div id="<?php echo $name; ?>" class="row"><?php
                            echo '<h3>' . Text::_($fieldSet->label) . '</h3>';
                            foreach ($this->form->getFieldset($name) as $field) {
                               // if we have a date field we have to set default dateformat for the calendar
                               if ($field->fieldname === "f_date_attribute_value") {
                                   $dateFormatField = $this->form->getField('f_date_format', 'defaultvalue');
                                   if ($dateFormatField->value != "") {
                                       // get date format for javascript
                                       $dFormat = explode(";", $dateFormatField->value);
                                       if (isset($dFormat[1])) {
                                           $this->form->setFieldAttribute("f_date_attribute_value", "format", $dFormat[1], 'defaultvalue');
                                       }
                                   }
                               }
                               echo $field->renderField();
                            } ?>
                        </div> <?php
                    } ?>
                </div>
            </div>
            <div class="row-fluid">
                <div class="col-lg-12 col-xl-12"><?php
                    foreach ($fieldsetsWithOptionlist as $name) {
                        $groupFieldSet = $this->form->getFieldset($name, 'defaultvalue'); ?>
                        <div id="<?php echo $name; ?>" class="row"><?php
                        foreach ($groupFieldSet as $field) {
                            echo $field->renderField();
                        }
                        ?>
                        </div><?php
                    } ?>
                </div>
            </div>
            </div><?php
            echo HTMLHelper::_('uitab.endTab');
            // tab advanced
            echo HTMLHelper::_('uitab.addTab', 'myTab', 'visfield-advanced-detailso', Text::_('COM_VISFORMS_TAB_ADVANCED')); ?>
            <div class="row">
                <?php
                    $fsAdvanced = $this->form->getFieldset('visfield-advanced-details');
                    foreach ($fsAdvanced as $field) {
                        echo $field->renderField();
                    }
                    $fslayoutcustomtext= $this->form->getFieldset('layout-custom-text');
                    foreach ($fslayoutcustomtext as $field) {
	                    echo $field->renderField(array("class" => $field->class));
                    } ?>

            </div><?php
            echo HTMLHelper::_('uitab.endTab');
            // tab layout
            echo HTMLHelper::_('uitab.addTab', 'myTab', 'visfield-advanced-layout', Text::_('COM_VISFORMS_TAB_LAYOUT')); ?>
            <div class="row">
                <div class="col-12"><?php
                    $btgridLayout = $this->form->getFieldset('visfield-bootstrap-grid');
                    if (!empty($btgridLayout)) {
                        echo '<div id="bootstrapGridSizes" class="row">';
                        echo '<div class="col-12 col-xl-6">';
                        // control group width settings on the left side
                        foreach ($btgridLayout as $field) {
                            if (str_starts_with($field->id, 'jform_gridSizes_fieldsPer')) {
                                echo $field->renderField();
                            }
                        }
                        echo '</div>';
                        echo '<div class="col-12 col-xl-6">';
                        // label width settings on the right side
                        foreach ($btgridLayout as $field) {
                            if (str_starts_with($field->id, 'jform_gridSizes_labelBootstrap')) {
                                echo $field->renderField();
                            }
                        }
                        echo '</div>';
                        echo '</div>';
                    }
                    $fsLayout = $this->form->getFieldset('visfield-layout-details');
                    echo '<div class="row">';
                    foreach ($fsLayout as $field) {
                        echo $field->renderField();
                    }
                    echo '</div>';?>
                </div>
            </div>
            <?php
            echo HTMLHelper::_('uitab.endTab');
            // tab data usage
            echo HTMLHelper::_('uitab.addTab', 'myTab', 'visfield-advanced-usage', Text::_('COM_VISFORMS_TAB_DATA_USAGE')); ?>
            <div class="row"><?php
                    $fsUsage = $this->form->getFieldset('data-usage');
                    foreach ($fsUsage as $field) {
                        echo $field->renderField();
                    } ?>
            </div><?php
            echo HTMLHelper::_('uitab.endTab');
            foreach ($formFieldSets as $name => $fieldSet) {
                // custom tabs: VisFieldPluginHelper
                // supports sub tabs only for visField Plugins
                if (str_contains($name, 'visfield-extension')) {
                    // do not render fieldset which should be displayed in child tabs: fieldset has attribute parent
                    if (!empty($fieldSet->parent)) {
                        continue;
                    }
                    if (!empty($fieldSet->hassubtabs)) {
                        // there are child fieldsets, render them as child tabs
                        echo HTMLHelper::_('uitab.addTab', 'myTab', $name, Text::_($fieldSet->label)); ?>
                        <div class="row">
                            <div class="col-lg-12"><?php
                                foreach ($this->form->getFieldset($name) as $field) {
                                    $dataAttributes = $field->getDataAttributes();
                                    if (!empty($dataAttributes) && is_array($dataAttributes) && !empty($dataAttributes['data-render-in-child-tab'])) {
                                        // skip field in main tab
                                    }
                                    else {
                                        echo $field->renderField();
                                    }
                                }
                                $subTabFieldsets = array();
                                foreach ($formFieldSets as $childName => $childFieldSet) {
                                    if (!empty($childFieldSet->parent) && $childFieldSet->parent === $name) {
                                        // store child fieldsets in variable
                                        $subTabFieldsets[$childName] = $childFieldSet;
                                        // unset set child fieldset from $formFieldSets;
                                        unset($formFieldSets[$childName]);
                                    }
                                }
                                // render child fieldsets in sub tabs
                                if (!empty($subTabFieldsets)) { ?>
                                    <div>
                                    <?php echo HTMLHelper::_('uitab.startTabSet', 'mySubTab' . $subFieldsetCounter, array( 'recall' => true, 'breakpoint' => 768));
                                    foreach ($subTabFieldsets as $childName => $childFieldSet) {

                                        echo HTMLHelper::_('uitab.addTab', 'mySubTab'. $subFieldsetCounter, $childName, Text::_($childFieldSet->label));
                                        echo '<div class="row">';
                                        foreach ($this->form->getFieldset($childName) as $field) {
                                            if ($field->type == 'Editor') {
                                                $class = $field->parentclass;
                                                if (empty($class)) {
                                                    $class = 'col-12';
                                                }
                                                echo '<div class="'.$class.'">';
                                                echo $this->form->getLabel($field->fieldname,  $field->group);
                                                echo $this->form->getInput($field->fieldname,  $field->group);
                                                echo '</div>';
                                            }
                                            else {
                                                echo $field->renderField();
                                            }
                                        }
                                        echo '</div>';
                                        echo HTMLHelper::_('uitab.endTab');
                                    }
                                    echo HTMLHelper::_('uitab.endTabSet');
                                    $subFieldsetCounter++?>
                                    </div><?php
                                }?>
                            </div>
                        </div>
                        <?php echo HTMLHelper::_('uitab.endTab');
                        // unset fieldset (main tab)
                        unset($formFieldSets[$name]);
                        continue;
                    }
                    echo HTMLHelper::_('uitab.addTab', 'myTab', $name, Text::_($fieldSet->label)); ?>
                    <div class="col-lg-12 col-xl-6"><?php
                        foreach ($this->form->getFieldset($name) as $field) {
                            if ($field->type == 'Editor') {
                                echo $this->form->getLabel($field->fieldname,  $field->group);
                                echo $this->form->getInput($field->fieldname,  $field->group);
                                echo '<div class="clearfix"></div>';
                            }
                            else {
                                echo $field->renderField();
                            }
                        } ?>
                    </div><?php
                    echo HTMLHelper::_('uitab.endTab');
                }
            }
            if ($this->canDo->get('core.admin')) {
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'permissions', Text::_('COM_VISFORMS_FIELDSET_FIELD_RULES', true));
                echo $this->form->getInput('rules');
                HTMLHelper::_('uitab.endTab');
            }

            echo HTMLHelper::_('uitab.endTabSet'); ?>
        </div>
    </div>
</form>
<?php
$token = Session::getFormToken();
$url = 'index.php?option=com_visforms&task=' . $this->editViewName . '.saveAjaxTextarea&id='. $this->id;
$options =  "{".
    "texts : ".
    "{emptyMessage: '" . Text::_('COM_VISFORMS_EMPTY_TEXTAREA_MESSAGE', true). "',".
    "errorMessage : '" . Text::_('COM_VISFORMS_AJAX_SUBMIT_ERROR_MESSAGE', true) . "',".
    "submitButtonLabel : '" . Text::_('JAPPLY', true) . "',".
    "cancelButtonLabel : '" . Text::_('JCANCEL', true) . "',".
    "},".
    " params: ".
    "{t : '" . $token . "',".
    "url : '" . $url . "',".
    "controlsTemplate: '". (new FileLayout('div.ajax_submit'))->render() ."',".
    "},".
    "}";
$js = <<<JS
jQuery(document).ready(function() {
    // create visformsAjaxSubmit Object for specified textareas and attach it to dom element
    jQuery(".visajax-submit").createVisformsAjaxSubmit($options);
})
JS;

$wa->addInlineScript($js);