/**
 * @package    Visforms.JavaScript
 * @copyright  Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// callback for google invisible recaptcha
// Invisible Recaptcha is execute asynchron in validator.submitHandler
// therefore we have to return false in submitHandler and do the proper form submit in the Recaptcha callback function
// the recaptcha response field is rendered by Google Api
// it always has the same id, which cannot be changed: g-recaptcha-response
// this is why we can always only have on recaptcha in one page!
function iGRCallback (token) {
  // get captcha response field
  let recpatchaField = document.getElementById('g-recaptcha-response');
  // find parent form
  let form = recpatchaField.closest('form');
  // get id of parent form
  let parentFormId = form.id;
  // set token value in response field
  recpatchaField.value = token;
  // submit form
  form.submit();
  // disable buttons
  jQuery(form).find('input[type="submit"]').prop("disabled", true);
  jQuery(form).find('input[type="reset"]').prop("disabled", true);
  jQuery(form).find('input[type="image"]').prop("disabled", true);
  visForm.showProcessFormMsg(parentFormId);
}

((window, document) => {
  window.VfInitIGReCaptcha = () => {
const optionKeys = ['sitekey', 'badge', 'size', 'tabindex', 'callback', 'expired-callback', 'error-callback'];
[].forEach.call(document.getElementsByClassName('g-recaptcha'), function(element,i,htmlcollection) {
  let options = {};
  if (element.dataset) {
    options = element.dataset;
  } else {
    optionKeys.forEach(key => {
      const optionKeyFq = `data-${optionKeys[key]}`;
      if (element.hasAttribute(optionKeyFq)) {
        options[optionKeys[key]] = element.getAttribute(optionKeyFq);
      }
    });
  }

  // Set the widget id of the recaptcha item
  element.setAttribute('data-recaptcha-widget-id', window.grecaptcha.render(element, options));

  // Execute the invisible reCAPTCHA
  // window.grecaptcha.execute(element.getAttribute('data-recaptcha-widget-id'));
});
};
})(window, document);
