<?php
/**
 * Visforms label html for captcha field for bootstrap default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;

if (!empty($displayData)) :
	if (isset($displayData['form']) && isset($displayData['name'])) :
		$form = $displayData['form'];
	    $name = $displayData['name'];
	    $htmlTag = isset($displayData['htmlTag']) ? $displayData['htmlTag'] : 'div';
		$labelClass = $form->captchaLabelClasses;
        $captchalabel = (!empty($form->captchalabel)) ? $form->captchalabel : Text::_('COM_VISFORMS_CAPTCHA_LABEL');
        $version = (int) $form->captcha;
        $for = ($htmlTag === 'label') ? (' for="' . $name . '"')  : '';
        $html = array();
        $html[] = '<'.$htmlTag.' class="' . $labelClass . '" id="captcha-lbl'.$form->context.'"'. $for . '>';
        if (empty($form->showcaptchalabel)) {
            $html[] = $captchalabel;
        }
        else {
            $html[] = '<span class="visually-hidden">' . $captchalabel. '</span>';
        }
        $html[] = '</'.$htmlTag.'>';
        echo implode('', $html);
	endif;
endif;