<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;

if (!empty($displayData) && isset($displayData['form']) && isset($displayData['id']) &&
    (isset($displayData['onclick']) || (isset($displayData['data-item-id']) && isset($displayData['data-item-task']) && isset($displayData['data-item-context'])))
) {
    HTMLHelper::_('bootstrap.tooltip');
	$form = $displayData['form'];
	$id = $displayData['id'];
	$onclick = (isset($displayData['onclick'])) ? ' onclick="' . $displayData['onclick'] .'"' : '';
    $dataItemId = (isset($displayData['data-item-id'])) ? " data-item-id=" . $displayData['data-item-id'] : '';
    $dataItemTask= (isset($displayData['data-item-task'])) ? " data-item-task=" . $displayData['data-item-task'] : '';
    $dataItemContext = (isset($displayData['data-item-context'])) ? " data-item-context=" . $displayData['data-item-context'] : '';
    $dataUrl = (isset($displayData['data-url'])) ? " data-item-url=" . $displayData['data-url'] : '';
    $dataUrlOrg = (isset($displayData['data-url-org'])) ? " data-item-url-org=" . $displayData['data-url-org'] : '';
    $dataItemFid = (isset($displayData['data-item-fid'])) ? " data-item-fid=" . $displayData['data-item-fid'] : '';
    $dataAttribs = '';
    // data attributes are used if no onclick handler is set
    // only set data Attributes if no onclick handler is set
    if (empty($onclick)) {
        $dataAttribs = $dataItemId . $dataItemTask . $dataItemContext . $dataUrl . $dataUrlOrg;
    }
	$extension = (!empty($displayData['extension'])) ? $displayData['extension'] : 'component';
	$htmlTag = (!empty($displayData['htmlTag'])) ? $displayData['htmlTag'] : 'td';
	$class = (!empty($displayData['class'])) ? ' class="' . $displayData['class'] . '"' : '';
	$pparams = (!empty($displayData['pparams'])) ? $displayData['pparams'] : array();
	$viewType = (!empty($displayData['viewType'])) ? $displayData['viewType'] : 'column';
	$btnclass = (!empty($displayData['btnclass'])) ? $displayData['btnclass'] . ' visToolTip  vfdv-task': 'visToolTip  vfdv-task';
	$title = (!empty($displayData['title'])) ? $displayData['title'] : Text::_('COM_VISFORMS_DOWNLOAD_PDF') ;
	$displayPdfButton = false;
	$name='displaypdfexportbutton';

	switch ($extension) {
		case 'vfdataview' :
			$name .= '_plg';
			break;
		default:
			if ($viewType == 'column') {
				$name .= '_list';
			}
			if ($viewType == 'row') {
				$name .= '_detail';
			}
			break;
	}
	if (!empty($form->$name) && !empty($form->singleRecordPdfTemplate)) {
		$displayPdfButton = true;
	}

	if (!empty($displayPdfButton)) {
		HTMLHelper::_('visforms.loadDataTaskJs');
		echo '<' . $htmlTag . $class . '>';

		echo '<a class="' . $btnclass . '"' . $onclick . ' href="#" title="' . htmlspecialchars($title, ENT_COMPAT) . '" data-bs-toggle="tooltip"' . $dataAttribs .'>';
		echo '<span class="icon-file"></span>';
		echo '</a>';
		echo '</' . $htmlTag . '>';
	}
}