<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Model\VisdatasModel;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholder;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;
use Visolutions\Component\Visforms\Administrator\Model\Helper\FieldParamNameShortener;

if (!empty($displayData) && isset($displayData['form']) && isset($displayData['data']) && isset($displayData['text'])) {
	$form = $displayData['form'];
	$data = $displayData['data'];
    $text = $displayData['text'];

    if (!empty($displayData['fields'])) {
        $fieldDefinitions = $displayData['fields'];
    }
    else {
        // get the field definitions of all form fields
        $adminDataModel = new VisdatasModel(array('id' => $form->id, 'ignore_request' => true));
        $where = " typefield NOT in('submit', 'image', 'reset', 'fieldsep', 'pagebreak')";
        $fieldDefinitions = $adminDataModel->getDatafields($where);
        $fieldDefinitions = json_decode(json_encode($fieldDefinitions));
    }

    $hasSub = AefHelper::checkAEF();
    if (!empty($fieldDefinitions)) {
        $n = count($fieldDefinitions);
        for ($i = 0; $i < $n; $i++) {
            $helper = new FieldParamNameShortener($fieldDefinitions[$i]);
            $fieldDefinitions[$i] = $helper->makeShort(false);
        }
    }
    // fieldtype url and file allow to display a link in the frontend data views
    // which may have a custon link text, stored in $field->link_text
    // which may use Visforms Placeholder, which have to be replaced first
    if (!empty($text)) {
        $dArray = json_decode(json_encode($data), true);
        $placeholders = new VisfieldPlaceholder($text);
        while ($placeholders->hasNext()) {
            $placeholders->getNext();
            $replace = '';
            $pName = $placeholders->getPlaceholderPart('name');
            if (empty($pName)) {
                // should never happen: just remove the placeholderstring
                $placeholders->replace('');
                continue;
            }
            else if ($placeholders->isNonFieldPlaceholder()) {
                $pParams = $placeholders->getPlaceholderPart('params');
                // overhead placeholder
                switch ($pName) {
                    case 'formid' :
                        $replace = (!empty($form->id)) ? $form->id : '';
                        break;
                    case 'formtitle' :
                        $replace = (!empty($form->title)) ? $form->title : '';
                        break;
                    case 'id' :
                        $replace = (!empty($dArray['id'])) ? $dArray['id'] : '';
                        break;
                    case  'currentdate' :
                        $placeholder = VisfieldPlaceholderEntry::getInstance($pParams, null, $pName);
                        $replace = $placeholder->getReplaceValue();
                        break;
                    default :
                        $placeholder = VisfieldPlaceholderEntry::getInstance($pParams, ((array_key_exists($pName, $dArray)) ? $dArray[$pName] : null), $pName);
                        $replace = $placeholder->getReplaceValue();
                        break;
                }
            }
            else if (is_array($fieldDefinitions)) {
                foreach ($fieldDefinitions as $replaceField) {
                    $fieldName = $replaceField->name;
                    if ($pName === $fieldName) {
                        $pParams = $placeholders->getPlaceholderPart('params');
                        $dataName = 'F' . $replaceField->id;
                        $placeholder = VisfieldPlaceholderEntry::getInstance($pParams, $dArray[$dataName], $replaceField->typefield, $replaceField);
                        $replace = $placeholder->getReplaceValue();
                    }
                }
            }

            $placeholders->replace($replace);
            unset($replace);
            $text = $placeholders->getText();
        }
    }
    // clean php notices and warnings from output buffer, store in variable for further use
    $buffer = ob_get_contents();
    ob_clean();
    echo $text;
}