<?php
/**
 * Visforms html for form footer without summary page
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Language\Text;

if (!empty($displayData)) :
	if (isset($displayData['form']) && isset($displayData['nbFields']) && isset($displayData['hasRequired'])) :
		$form = $displayData['form'];
		$nbFields = $displayData['nbFields'];
		$hasRequired = $displayData['hasRequired'];
		$backButtonText = (!empty($form->backbtntext)) ? $form->backbtntext : Text::_('COM_VISFORMS_STEP_BACK');
		$backBtnClass = (!empty($form->backbtncssclass)) ? 'btn back_btn col-auto ' . $form->backbtncssclass : 'btn back_btn col-auto';
        $mpfButtonPosition = (!empty($form->mpfbuttonposition)) ? $form->mpfbuttonposition : '';
        if (!empty($form->honeypot)) {
            echo LayoutHelper::render('visforms.custom.honeypot', array('form' => $form), null, array('component' => 'com_visforms'));
        }
		if (!empty($form->mpdisplaytype) && !empty($form->accordioncounter)) {
			echo '</div>';
			echo '</div>';
			echo '</div>';
			echo '</div>';
		}

		// Explanation for * if at least one field is required above captcha
		if ($hasRequired == true && $form->required == 'captcha') {
			echo LayoutHelper::render('visforms.requiredtext.bt5', array(), null, array('component' => 'com_visforms'));
		}
		if (isset($form->captcha)) {
			echo LayoutHelper::render('visforms.captcha.bt5', array('form' => $form), null, array('component' => 'com_visforms'));
		}
		// Explanation for * if at least one field is required above submit
		if ($hasRequired == true && $form->required == 'bottom') {
			echo LayoutHelper::render('visforms.requiredtext.bt5', array(), null, array('component' => 'com_visforms'));
		}
		echo '<div class="clearfix"></div>';
		for ($i = 0; $i < $nbFields; $i++) {
			$field = $form->fields[$i];
			if (!empty($field->sig_in_footer)) {
				echo $field->controlHtml;
				echo '<div class="clearfix"></div>';
			}
		}
        // no multi page form, render all buttons centered
        $actionControls = LayoutHelper::render('visforms.footers.bt5.actioncontrols', array('form' => $form, 'nbFields' => $nbFields), null, array('component' => 'com_visforms'));
        if (empty($form->steps)) {
            echo $actionControls;
        }
        else {
            echo LayoutHelper::render('visforms.footers.bt5.mpfnavigation', array('addResetAncor' => false, 'nextBtnClass' => '', 'nextBtnText' => '', 'backBtnText' => $backButtonText, 'backBtnClass' => $backBtnClass, 'step' => $form->steps, 'actionControls' => $actionControls, 'hideNextButton' => true, 'mpfButtonPosition' => $mpfButtonPosition), null, array('component' => 'com_visforms'));
        }
	endif;
endif;