<?php
/**
 * Visforms html for admincontrollblock
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Language\Text;

if (!empty($displayData)) :
	if (isset($displayData['form']) && isset($displayData['nbFields']) && isset($displayData['hasRequired'])) :
		$form = $displayData['form'];
		$nbFields = $displayData['nbFields'];
		$hasRequired = $displayData['hasRequired'];
		$summarypageid = $displayData['summarypageid'];
		$backButtonText = (!empty($form->backbtntext)) ? $form->backbtntext : Text::_('COM_VISFORMS_STEP_BACK');
		$backBtnClass = (!empty($form->backbtncssclass)) ? 'btn back_btn ' . $form->backbtncssclass : 'btn back_btn col-auto';
		$summaryButtonText = (!empty($form->summarybtntext)) ? $form->summarybtntext : Text::_('COM_VISFORMS_SUMMARY');
		$summayBtnClass = (!empty($form->summarybtncssclass)) ? 'btn summary_btn ' . $form->summarybtncssclass : 'btn summary_btn';
		$correctButtonText = (!empty($form->correctbtntext)) ? $form->correctbtntext : Text::_('COM_VISFORMS_CORRECT');
        $correctBtnClass = (!empty($form->correctbtncssclass)) ? 'btn correct_btn ' . $form->correctbtncssclass : 'btn correct_btn';
		$mpfocusclasss = (!empty($form->mpforcusclass)) ? $form->mpforcusclass : '';
        $step = (!empty($form->steps)) ? $form->steps : 0;
        $mpfButtonPosition = (!empty($form->mpfbuttonposition)) ? $form->mpfbuttonposition : '';
        $actionControls = LayoutHelper::render('visforms.footers.bt5.actioncontrols', array('form' => $form, 'nbFields' => $nbFields), null, array('component' => 'com_visforms'));
        if (!empty($form->honeypot)) {
            echo LayoutHelper::render('visforms.custom.honeypot', array(), null, array('component' => 'com_visforms'));
        }
		if (!empty($form->mpdisplaytype) && !empty($form->accordioncounter)) {
			echo '</div>';
			echo '</div>';
			echo '</div>';
			echo '</div>';
		}
        echo LayoutHelper::render('visforms.footers.bt5.mpfnavigation', array('addResetAncor' => false, 'nextBtnClass' => $summayBtnClass, 'nextBtnText' => $summaryButtonText, 'backBtnText' => $backButtonText, 'backBtnClass' => $backBtnClass, 'step' => $step, 'mpfButtonPosition' => $mpfButtonPosition), null, array('component' => 'com_visforms'));
		echo '</fieldset>';
		echo '<fieldset class="fieldset-summarypage row'. $mpfocusclasss .'">';
		if ((!empty($form->summarydescription)) && (!empty($form->summarydescriptionposition)) && ($form->summarydescriptionposition == 'top')) {
			echo '<div class="summarydesc">' . $form->summarydescription . '</div>';
		}
		echo '<div id="' . $summarypageid . '_summarypage"></div>';
		// Explanation for * if at least one field is required above captcha
		if ($hasRequired == true && $form->required == 'captcha') {
			echo LayoutHelper::render('visforms.requiredtext.bt5', array(), null, array('component' => 'com_visforms'));
		}
		if (isset($form->captcha)) {
			echo LayoutHelper::render('visforms.captcha.bt5', array('form' => $form), null, array('component' => 'com_visforms'));
		}
		// Explanation for * if at least one field is required above submit
		if ($hasRequired == true && $form->required == 'bottom') {
			echo LayoutHelper::render('visforms.requiredtext.bt5', array(), null, array('component' => 'com_visforms'));
		}
		echo '<div class="clearfix"></div>';
		for ($i = 0; $i < $nbFields; $i++) {
			$field = $form->fields[$i];
			if (!empty($field->sig_in_footer)) {
				echo $field->controlHtml;
				echo '<div class="clearfix"></div>';
			}
		}
        echo LayoutHelper::render('visforms.footers.bt5.mpfnavigation', array('addResetAncor' => false, 'nextBtnClass' => '', 'nextBtnText' => '', 'backBtnText' => $correctButtonText, 'backBtnClass' => $correctBtnClass, 'step' => $form->steps, 'actionControls' => $actionControls, 'hideNextButton' => true, 'isSummaryPage' => true, 'mpfButtonPosition' => $mpfButtonPosition), null, array('component' => 'com_visforms'));
		if ((!empty($form->displaysummarypage)) && ((!empty($form->summarydescription)) && (!empty($form->summarydescriptionposition)) && ($form->summarydescriptionposition == 'bottom'))) {
			echo '<div class="summarydesc">' . $form->summarydescription . '</div>';
		}
        // closing fieldset in parent file
	endif;
endif;