<?php
/**
 * Visforms html for form footer without summary page
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Language\Text;

if (!empty($displayData)) :
	if (isset($displayData['form']) && isset($displayData['nbFields']) && isset($displayData['hasRequired'])) :
		$form = $displayData['form'];
		$nbFields = $displayData['nbFields'];
		$hasRequired = $displayData['hasRequired'];
		$backButtonText = (!empty($form->backbtntext)) ? $form->backbtntext : Text::_('COM_VISFORMS_STEP_BACK');
        if (!empty($form->honeypot)) {
            echo LayoutHelper::render('visforms.custom.honeypot', array('form' => $form), null, array('component' => 'com_visforms'));
        }
		if (!empty($form->mpdisplaytype) && !empty($form->accordioncounter)) {
			echo '</div>';
			echo '</div>';
			echo '</div>';
			echo '</div>';
		}
		// Explanation for * if at least one field is required above captcha
		if ($hasRequired == true && $form->required == 'captcha') {
			echo LayoutHelper::render('visforms.requiredtext.default', array('form' => $form), null, array('component' => 'com_visforms'));
		}
		if (isset($form->captcha)) {
			echo LayoutHelper::render('visforms.captcha.default', array('form' => $form), null, array('component' => 'com_visforms'));
		}
		// Explanation for * if at least one field is required above submit
		if ($hasRequired == true && $form->required == 'bottom') {
			echo LayoutHelper::render('visforms.requiredtext.default', array('form' => $form), null, array('component' => 'com_visforms'));
		}
		for ($i = 0; $i < $nbFields; $i++) {
			$field = $form->fields[$i];
			if (!empty($field->sig_in_footer)) {
				echo $field->controlHtml;
			}
		}
		echo '<div class="visBtnCon">';
		if (!empty($form->steps) && (int) $form->steps > 1) {
			echo ' <input type="button" class="btn back_btn" value="' . $backButtonText . '" /> ';
		}
		for ($i = 0; $i < $nbFields; $i++) {
			$field = $form->fields[$i];
			if (isset($field->isButton) && $field->isButton === true) {
				echo $field->controlHtml;
			}
		}
		echo '</div>';
	endif;
endif;