<?php
/**
 * Visforms HTML class for fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Create HTML of a form field according to it's type
 *
 * @package        Joomla.Site
 * @subpackage    com_visforms
 * @since        1.6
 */
/* @deprecated 5.5 will be removed in Visforms 6.0
 *              Use \Visolutions\Component\Visforms\Site\Lib\Html\Field\HtmlFieldAwareTrait and
 *              the class \Visolutions\Component\Visforms\Site\Lib\Html\Field\BaseHtmlField instead
 */
abstract class VisformsHtml
{

	public static function getInstance($field, $decorable = null) {
		if (!(isset($field->typefield))) {
			return false;
		}
        $className = '\Visolutions\Component\Visforms\Site\Lib\Html\Field\\'.ucfirst($field->typefield).'Field';
        if (!class_exists($className)) {
            // return a default class?
            return false;
        }
		// delegate to the appropriate subclass
		return new $className($field, $decorable, $attribute_type = null);
	}
}