<?php
/**
 * Visforms hcaptcha date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace  Visolutions\Component\Visforms\Site\Hcaptcha;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;

class Hcaptcha
{
    private string $publicKey;
    private string $privatKey;
    private bool $enabled = false;
    private string $validationUrl = 'https://api.hcaptcha.com/siteverify';
    private string $errorMessage = '';
    private bool $valid = false;
    public function __construct() {
        $conficParams = ComponentHelper::getParams('com_visforms');
        $this->publicKey = $conficParams->get('hCpatchaPublicKey', '');
        $this->privatKey = $conficParams->get('hCpatchaPrivateKey', '');
        if (!empty($this->privatKey) && !empty($this->publicKey)) {
            $this->enabled = true;
        }
    }

    public function render() {
        if ($this->enabled) {
            $wa = Factory::getApplication()->getDocument()->getWebAssetManager();
            $wa->registerAndUseScript('com_visforms.hcaptcha.api', 'https://js.hcaptcha.com/1/api.js?recaptchacompat=off', [], ['defer' => true]);
            return '<div class="h-captcha required" data-sitekey="'.$this->publicKey.'" data-recaptchacompat="false">';
        }
        return '';
    }

    public function isEnabled() {
        return $this->enabled;
    }

    public function isValid() {
        return $this->valid;
    }

    public function getErrorMessage() {
        return $this->errorMessage;
    }

    // use file_get_contents instead of curl
    public function validate($token) {
        $post_data = http_build_query(
            array(
                'secret' => $this->privatKey,
                'response' => $token,
                'remoteip' => $_SERVER['REMOTE_ADDR']
            )
        );
        $opts = array('http' =>
            array(
                'method'  => 'POST',
                'header'  => 'Content-type: application/x-www-form-urlencoded',
                'content' => $post_data
            )
        );
        $context  = stream_context_create($opts);
        $response = file_get_contents('https://api.hcaptcha.com/siteverify', false, $context);
        if ($response === false || $response === '') {
            $this->errorMessage = Text::_('COM_VISFORMS_PROBLEMS_VALIDATING_CAPTCHA');
        }
        else {
            $response = json_decode($response, true);
            $this->valid = $response['success'];
            if (!$this->valid) {
                $this->errorMessage = Text::_('COM_VISFORMS_CAPTCHA_INVALID');
            }
        }
    }

    /* public function validate($token) {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $this->validationUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('response' => $token,'secret'=> $this->privatKey, 'sitekey' => $this->publicKey),
        ));

        $response = curl_exec($curl);
        $status = (int) curl_getinfo( $curl, CURLINFO_HTTP_CODE );
        if ($status === 200) {
            curl_close($curl);
            $response = json_decode($response, true);
            $this->valid = $response['success'];
            if (!$this->valid) {
                $this->errorMessage = Text::_('COM_VISFORMS_CAPTCHA_INVALID');
            }
        }
        else {
            $this->errorMessage = Text::_('COM_VISFORMS_PROBLEMS_VALIDATING_CAPTCHA');
        }
    }*/
}