<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Site\Lib\Message\RequiredMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\NotEmptyValidation;

class SignatureFieldBusiness extends Business
{
	public function getFields() {
		$this->setField();
		return $this->fields;
	}

	protected function setField() {
		$this->setCustomJs();
		$this->setIsDisabled();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->validatePostValue();
		}
		$this->addShowWhenForForm();
	}

	protected function validatePostValue(): void {
		$this->updateField();
	}

	public function validateRequired() {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			// check that a value is set if field is required
			if ((isset($this->field->signature_required)) && ($this->field->signature_required == true)) {
				// only for fields that are not disabled
				if (empty($this->field->isDisabled)) {
				    $validation = new NotEmptyValidation(array('value' => $this->field->attribute_value));
					if (!$validation->validate()) {
						$this->field->isValid = false;
                        $message = new RequiredMessage($this->field->label, $this->field->custom_php_error);
                        $error = $message->getMessage();
						// attach error to form
						$this->setErrors($error);
					}
				}
			}
		}
		return $this->field;
	}

	protected function setCustomJs() {
		$task = Factory::getApplication()->getInput()->getCmd('task', '');
		$width = (isset($this->field->canvasWidth) && (int) $this->field->canvasWidth > 10) ? $this->field->canvasWidth : 280;
		$height = (isset($this->field->canvasHeight) && (int) $this->field->canvasHeight > 10) ? $this->field->canvasHeight : 120;
		$lockCanvas = ($task === 'editdata' || $task === 'saveedit') ? 'true' : 'false';
		$fieldOptions = '{fieldId: ' . $this->field->id . ', width: ' . $width . ', height: ' . $height . ', lockCanvas: ' . $lockCanvas . ', label: "' . addslashes($this->field->label) . '", fieldName: "'.addslashes($this->field->name).'", texts: {resetText:  "' . addslashes(Text::_( 'COM_VISFORMS_RESET_CANVAS' )).'", unlockText:  "' . addslashes(Text::_( 'COM_VISFORMS_UNLOCK_CANVAS' )).'", lockText:  "' . addslashes(Text::_( 'COM_VISFORMS_LOCK_CANVAS' )).'"}}';
		if (isset($this->field->api) && $this->field->api === "1") {
            $script = 'jQuery(document).ready(function() {visForm.initVfSignaturePad(' . $fieldOptions . ');});';
        }
		else {
            $script = 'jQuery(document).ready(function() {visForm.initVfSignature(' . $fieldOptions . ');});';
        }
		$this->field->customJs[] = $script;
	}

	public function setFieldValueProperties() {
		// stored (validated) "userinput" in new parameter
		$this->field->userInput = $this->getUserInputForJs();
		// set value, which is first displayed to the configuration defaults
		$this->field->attribute_value = $this->field->configurationDefault;
		return $this->field;
	}

	private function getUserInputForJs() {
		$value = $this->field->attribute_value;
		if ($this->isEditTask) {
			// use configuartion default as default, if field is disabled
			if (!empty($this->field->isDisabled)) {
				$value = $this->field->configurationDefault;
			}
		}
		if ($this->isRedisplayEditTask) {
			if (!empty($this->field->isDisabled)) {
				// if field was originally not disabled use dbValue
				$fieldsDisabledState = Factory::getApplication()->getUserState('com_visforms.fieldsDisabledState.' . $this->form->context, null);
				if (!empty($fieldsDisabledState) && (is_array($fieldsDisabledState)) && (empty($fieldsDisabledState[$this->field->name])) && isset($this->field->editValue)) {
					$value = $this->field->editValue;
				}
				else {
					$value = $this->field->configurationDefault;
				}
			}
		}
		return $value;
	}
}