<?php
/**
 * Visforms field fieldseparator class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class FieldsepField extends Field
{
	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setShowLabel();
        $this->setNoFocus();
	}

	protected function setFieldDefaultValue(): void {
		// Nothing to do
	}

	protected function setDbValue(): void {
        // Nothing to do
	}

	protected function setRedirectParam(): void {
        // Nothing to do
	}

	protected function setShowLabel() {
		$this->field->show_label = 1;
	}

    protected function setConfigurationDefault(): void {
        // Nothing to do
    }

    protected function setEditOnlyFieldDbValue(): void {
        // Nothing to do
    }
}