<?php
/**
 * Visforms field hidden class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;
use Visolutions\Component\Visforms\Site\Lib\Validation\EqualToValidation;

class HiddenField extends Field
{

	public function __construct($field, $form) {
		parent::__construct($field, $form);
		// store potential query Values for this field in the session
		$this->setQueryValue();
		$this->postValue = $this->input->post->get($field->name, '', 'STRING');
	}


	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->prepareFieldForNoEditSqlProcess();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		$this->fillWith();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setRedirectParam();
		$this->setCustomJs();
	}

	protected function setFieldDefaultValue(): void {
		$field = $this->field;
		if ($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) {
			if ((isset($this->field->editValue))) {
				$this->field->attribute_value = $this->field->editValue;
			}
			$this->field->dataSource = 'db';
			return;
		}
		// if we have a POST Value, we use this
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			//this will create a error message on form display
			$this->validateUserInput('postValue');
			if (isset($_POST[$field->name])) {
				$this->field->attribute_value = $this->postValue;
			}
			$this->field->dataSource = 'post';
			return;
		}
		// if we have a GET Value and field may use GET values, we uses this
		if (isset($field->allowurlparam) && ($field->allowurlparam == true)) {
			$urlparams = Factory::getApplication()->getUserState('com_visforms.urlparams.' . $this->form->context, null);
			if (!empty($urlparams) && (is_array($urlparams)) && (isset($urlparams[$this->field->name]))) {
				$queryValue = $urlparams[$this->field->name];
			}
			if (isset($queryValue)) {
				$this->field->attribute_value = $queryValue;
				$this->field->dataSource = 'query';
				return;
			}
		}
		// Nothing to do
	}

	protected function validateUserInput($inputType) {
	    // validate that the POST Value matches the value set as default value by fill_with
        // we can only perform this validation if fill_with = 0
        // and the value is not modified by a value sql statement
		$value = $this->$inputType;
		// if fill_with = 0 , we want to validate, that the user input matches the default value
		if ($this->field->fillwith !== '0') {
			return;
		}
		if (!empty($this->field->allowurlparam)) {
		    return;
        }
		// only check, that user input === attribute_value if a attribute_value is set (!=="")
		if ((!isset($this->field->attribute_value)) || ($this->field->attribute_value === '')) {
			return;
		}
		// fill_with = 0 and
		// user input must match the attribute value; if no user input is set this is invalid, too
        $validation = new EqualToValidation(array('value' => $value, 'cvalue' => $this->field->configurationDefault));
		if (!(isset($value) && $validation->validate())) {
            // invalid user inputs - set field->isValid to false
            $this->field->isValid = false;
            // set the Error Message
            $error = Text::sprintf('COM_VISFORMS_INVALID_HIDDEN_FIELD_USER_INPUT_DOES_NOT_MATCH_DEFAULT', $this->field->label);
            $this->setErrorMessageInForm($error);
		}
	}

	protected function setDbValue(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->field->dbValue = $this->postValue;
		}
	}

	protected function setEditOnlyFieldDbValue(): void {
		$this->field->editOnlyFieldDbValue = $this->field->configurationDefault;
	}

	protected function setRedirectParam(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post' && (!empty($this->field->addtoredirecturl))) {
			$this->field->redirectParam = $this->postValue;
		}
	}

	protected function setConfigurationDefault(): void {
		$this->field->configurationDefault = $this->field->attribute_value;
		if (!$this->isEditOrSaveEditTask) {
			$urlparams = Factory::getApplication()->getUserState('com_visforms.urlparams.' . $this->form->context, null);
			if (!empty($urlparams) && (is_array($urlparams)) && (isset($urlparams[$this->field->name]))) {
				$queryValue = $urlparams[$this->field->name];
			}
			// if form was originally called with valid url params, reset to this url params
			$this->field->configurationDefault = (isset($this->field->allowurlparam) && ($this->field->allowurlparam == true) && isset($queryValue)) ? $queryValue : $this->field->attribute_value;
		}
	}
}