<?php
/**
 * Visforms field pagebreak class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class PagebreakField extends Field
{
	protected function setField(): void {
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->cleanFieldProperties();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setFieldDefaultValue();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setMpDisplayType();
		if (empty($this->field->mpdisplaytype)) {
			$this->addFormStep();
			$this->setMpfButtonPosition();
		}
		else if ($this->field->mpdisplaytype == 1) {
			$this->setAccordionCounter();
			$this->setAccordionId();
			$this->setFirstPanelState();
			HTMLHelper::_('bootstrap.collapse');
		}
		$this->setBackBtnText();
		$this->setBackBtnCssClass();
	}

	protected function setFieldDefaultValue(): void {
		// Nothing to do
	}

	protected function setDbValue(): void {
        // Nothing to do
	}

	protected function setRedirectParam(): void {
        // Nothing to do
	}

	protected function setBackBtnText() {
		$this->field->backbtntext = $this->form->backbtntext;
	}

	protected function setBackBtnCssClass() {
		$this->field->backbtncssclass = isset($this->form->backbtncssclass) ? $this->form->backbtncssclass : '';
	}

	protected function setMpDisplayType() {
		$this->field->mpdisplaytype = isset($this->form->mpdisplaytype) ? $this->form->mpdisplaytype : 0;
	}

	protected function setAccordionCounter() {
		if ((isset($this->form->accordioncounter)) && (is_numeric($this->form->accordioncounter))) {
			$this->form->accordioncounter++;
		} else {
			$this->form->accordioncounter = (int) 1;
		}
		$this->field->accordioncounter = $this->form->accordioncounter;
	}

	protected function setAccordionId() {
		$this->field->accordionid = (!empty($this->form->context)) ? $this->form->context . 'accordion' : 'visform' . $this->form->id . 'accordion';
	}

	protected function setFirstPanelState() {
		$this->field->firstpanelcollapsed = isset($this->form->firstpanelcollapsed) ? $this->form->firstpanelcollapsed : 0;
	}

	protected function setMpfButtonPosition() {
        $this->field->mpfbuttonposition = isset($this->form->mpfbuttonposition) ? (string) $this->form->mpfbuttonposition : '';
    }

	protected function cleanFieldProperties() {
		$this->field->customtext = '';
	}

    protected function setConfigurationDefault(): void {
        // Nothing to do
    }

    protected function setEditOnlyFieldDbValue(): void {
        // Nothing to do
    }
}