<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class SignatureField extends Field
{
	public function __construct($field, $form) {
		parent::__construct($field, $form);
		$this->postValue = $this->input->post->get($field->name, '', 'STRING');
	}

	protected function setField(): void {
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setRedirectParam();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setShowRequiredAsterix();
        $this->replaceLabelWithCustomText();
	}

	protected function setFieldDefaultValue(): void {
		if ($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) {
			if ((isset($this->field->editValue))) {
				$this->field->attribute_value = $this->field->editValue;
			}
			$this->field->dataSource = 'db';
			return;
		}
		// if we have a POST Value, we set the dataSource attibute
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			$this->field->attribute_value = $this->postValue;;
			$this->field->dataSource = 'post';
		}
        // we use default values
	}

	protected function setDbValue(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->field->dbValue = $this->postValue;
		}
	}

	protected function setEditOnlyFieldDbValue(): void {
		$this->field->editOnlyFieldDbValue = $this->field->configurationDefault;
	}

	protected function setRedirectParam(): void {
		// nothing to do
	}

	protected function setConfigurationDefault(): void {
		$this->field->configurationDefault = $this->field->attribute_value;
	}

	// custom implementation
    // do not set a stored signature into editValue, if selected api and stored value do not match
    protected function setEditValue(): void {
        parent::setEditValue();
        $api = $this->field->api ?? '';
        if ($api === "1") {
            if (!empty($this->field->editValue)) {
                if ((str_starts_with($this->field->editValue, 'image/jsignature;base30'))) {
                    $this->field->editValue = '';
                }
            }
        }
    }
}