<?php
/**
 * Visforms decorator class for HTML controls
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterCustomtextPrepareEvent;
use Joomla\Event\DispatcherInterface;
use Visolutions\Component\Visforms\Site\Lib\Html\Field\BaseHtmlField;
use Visolutions\Component\Visforms\Site\Lib\Layout\Helper\BaseLayoutHelper;
use Visolutions\Component\Visforms\Site\Lib\Layout\Helper\Uikit3FieldLayoutHelper;
use Visolutions\Component\Visforms\Site\Lib\Layout\Helper\Bt5FieldLayoutHelper;

abstract class Control implements ControlInterface
{
	protected $field;
	protected string $layout;
	protected array $breakPoints;
	protected BaseLayoutHelper $fieldHelper;

	public function __construct(BaseHtmlField $field, $layout) {
		$this->field = $field;
		$this->layout = $layout;
        $this->setBreakPoints();
        $this->setFieldHelper();
    }

    abstract public function getControlHtml();

    public function createLabel() {
        return '';
    }

    protected function getLabelClass() {
        switch ($this->layout) {
	        case 'uikit3' :
	        case 'edituikit3' :
            case 'bt5' :
            case 'editbt5' :
				$labelClass = $this->fieldHelper->getLabelClass();
		        break;
            default :
                $labelClass = ' visCSSlabel ';
                break;
        }
        return $labelClass;
    }

    public function getCustomText() {
        $class = '';
        $html = '';
    	switch ($this->layout) {
            case 'bt5' :
            case 'editbt5' :
            case 'uikit3' :
            case 'edituikit3' :
			    $class = $this->getCtClasses();
			    break;
		    default :
		        $class = 'visCustomText';
			    break;
	    }
        $field = $this->field->getField();
        // input
        if (isset($field->customtext) && ($field->customtext != ''))
        {
            PluginHelper::importPlugin('content');
            $customtext = HTMLHelper::_('content.prepare', $field->customtext);
            if (in_array($this->layout, array('uikit3', 'edituikit3'))) {
            	$html .= '<label class="'.$this->getLabelClass().'"></label>';
            }
            $html .= '<div class="'.$class.' ">' . $customtext . '</div>';
        }
        // Trigger onVisformsAfterCustomtextPrepare event to allow changes on field properties before control html is created
        PluginHelper::importPlugin('visforms');
		// make custom adjustments to the custom text html
        $afterCustomTextPrepareEvent = new VisformsAfterCustomtextPrepareEvent('onVisformsAfterCustomtextPrepare', [
            'context' => 'com_visforms.field',
            'layout' => $this->layout,
            'html' => $html
        ]);
        $html = Factory::getContainer()->get(DispatcherInterface::class)->dispatch('onVisformsAfterCustomtextPrepare', $afterCustomTextPrepareEvent)->getArgument('html', $html);
        return $html;
    }

	// Override in components/com_visforms/src/Lib/Layout/Helper/LayoutnameFieldLayoutHelper.php with custom classes if necessary
	// proper indentation in regard to label width for elements that do not have a label in front of them, i.e. custom text, error div, checkbox control...
	public function getCtClasses() {
        if (!empty($this->fieldHelper) && method_exists($this->fieldHelper, 'getCtClasses')) {
            return $this->fieldHelper->getCtClasses();
        }
		$field = $this->field->getField();
		// width always 12 in total
		$ctClasses = ($field->labelBootstrapWidth != "12") ? 'offset-' . $field->labelBootstrapWidth . ' col-' . (12 - $field->labelBootstrapWidth) : 'col-12';
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'labelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$ctClasses .= ($field->$name != "12") ? ' offset-' . $lcBreakPoint . '-' . $field->$name . ' col-' . $lcBreakPoint . '-' . (12 - $field->$name) :  ' offset-' . $lcBreakPoint . '-0 col-' . $lcBreakPoint . '-12';
		}
		return $ctClasses;
	}

	// ui framework specific helper classes, used to render the framework specific html
	protected function setFieldHelper() {
    	switch ($this->layout) {
		    case 'uikit3' :
		    case 'edituikit3' :
			    $this->fieldHelper = new Uikit3FieldLayoutHelper();
		        $this->fieldHelper->setField($this->field->getField());
			    break;
            case 'bt5' :
            case 'editbt5' :
                $this->fieldHelper = new Bt5FieldLayoutHelper();
                $this->fieldHelper->setField($this->field->getField());
                break;
            default:
                break;
	    }
	}

    // ui framework specific responsive breakpoints
	protected function setBreakPoints() {
        switch ($this->layout) {
            case 'uikit3' :
            case 'edituikit3' :
            $this->breakPoints = array('Sm', 'Md', 'Lg', 'Xl');
                break;
            default:
                $this->breakPoints = array('Sm', 'Md', 'Lg', 'Xl', 'Xxl');
                break;
        }
    }

    public function getField() {
        return $this->field;
    }

    public function getLayout() {
        return $this->layout;
    }
}