<?php
/**
 * Visforms trait for HTML controls
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control;

// no direct access
use Visolutions\Component\Visforms\Site\Lib\Html\Field\BaseHtmlField;

defined('_JEXEC') or die('Restricted access');

trait ControlAwareTrait
{
	private $htmlControl;

	public function setControl(BaseHtmlField $field, string $layout) {
        $fieldType = $field->getField()->typefield;
	    switch ($layout) {
            case 'visforms' :
                $prefix = 'None';
                break;
            case 'edit' :
                $prefix = 'NoneEdit';
                break;
            case 'editbt5' :
                $prefix = 'Bt5Edit';
                break;
            case 'edituikit3' :
                $prefix = 'Uikit3Edit';
                break;
            default:
                $prefix = ucfirst($layout);
        }
	    $nameSpace = '\Visolutions\Component\Visforms\Site\Lib\Html\Control\\';
	    $classname = $nameSpace . $prefix . ucfirst($fieldType).'Control';
	    $this->htmlControl = new $classname($field, $layout);
    }

    public function getControl() {
        if ($this->htmlControl) {
            return $this->htmlControl;
        }
        throw new \UnexpectedValueException('FieldHtmlControl not set in ' . __CLASS__);
    }
}