<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Control;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\FileLayout;

class NoneSignatureControl extends Control {

	public function getControlHtml() {
		$field              = $this->field->getField();
		$clabel             = $this->createlabel();
		$field->clabel      = $clabel;
		$ccustomtext        = $this->getCustomText();
		$field->ccustomtext = $ccustomtext;
		$html               = '';
		$layout             = new FileLayout('visforms.default.signature.control', null);
		$layout->setOptions(array('component' => 'com_visforms'));
		$html .= $layout->render(array('field' => $field));

		return $html;
	}

	public function createLabel() {
		$field = $this->field->getField();
		$labelClass = $this->getLabelClass();
		$field->labelClass = $labelClass;
		// label
		$html = '';
		$layout = new FileLayout('visforms.default.signature.label', null);
		$layout->setOptions(array('component' => 'com_visforms'));
		$html .= $layout->render(array('field' => $field));
		return $html;
	}

	protected function getLabelClass () {
		return (isset($this->field->labelCSSclass) ? ($this->field->labelCSSclass . ' signaturelabel visCSSlabel') : 'signaturelabel visCSSlabel');
	}
}