<?php
/**
 * Visforms HTML class for fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

trait HtmlFieldAwareTrait
{
    private $htmlField;

    public function setHtmlField($field, $decorable = null) {
        $className = '\Visolutions\Component\Visforms\Site\Lib\Html\Field\\'.ucfirst($field->typefield).'Field';
        $this->htmlField = new $className($field, $decorable, $attribute_type = null);
    }

    public function getHtmlField() {
        if ($this->htmlField) {
            return $this->htmlField;
        }
        throw new \UnexpectedValueException('Html field not set in ' . __CLASS__);
    }
}