<?php
/**
 * Visforms message class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace  Visolutions\Component\Visforms\Site\Lib\Message;

// no direct access

defined('_JEXEC') or die('Restricted access');

abstract class Message
{
	protected $name;
	protected $type;
	protected $text;
	// custom php error message set in field configuration
	protected $customText = '';
	protected $args;
	// custom error message which explains which additional characters are ignored in the validation and always allowed in the input
	protected $allowedCharMessage = '';

	public function __construct($name, $customText = '', $args = array(), $allowedCharMessage = '') {
		$this->name = $name;
        $this->args = $args;
        if (!empty($customText)) {
            $this->customText = $customText;
        }
        if (!empty($allowedCharMessage)) {
            $this->allowedCharMessage = $allowedCharMessage;
        }
	}

    public function getMessage() {
        return $this->setMessage();
    }

	abstract protected function setMessage(): string;
}