<?php
/**
 * Visforms validate custom regex class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class CustomValidation extends Validation
{
	protected $value;
	protected $regex;

	public function __construct($args) {
		parent::__construct($args);
		// we expect an item with key 'value' and an item with key 'regex' in $args
		$this->value = $this->args['value'] ?? "";
		$this->regex = $this->args['regex'] ?? "";
	}

	public function validate(): bool {
		if (!(preg_match($this->regex, $this->value))) {
			return false;
		} 
		else {
			return true;
		}
	}
}