<?php
/**
 * Visformsdata model for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Site\Model;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\ListModel;

class BaseVisformsdataModel extends ListModel {

	public function __construct($config = array(), ?MVCFactoryInterface $factory = null) {
		parent::__construct($config, $factory);
	}

    public function getPdfTemplates() {
        $db = $this->getDatabase();
        $query = $db->createQuery();
        $query->select($db->qn(array('id', 'title', 'filenames')));
        $query->from($db->quoteName('#__vispdf'));
        $query->where($db->quoteName('published') . ' = ' . 1);
        try {
            $db->setQuery($query);
            $pdfTemplates = $db->loadObjectList();
        }
        catch (\RuntimeException $e) {
            $pdfTemplates = false;
        }
        return $pdfTemplates;
    }
}