<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Plugin\EditorsXtd\Visformfields\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Editor\Button\Button;
use Joomla\CMS\Event\Editor\EditorButtonsSetupEvent;
use Joomla\Event\SubscriberInterface;

/**
 * Editor Visfields buton
 *
 * @package     Joomla.Plugin
 * @subpackage  Editors-xtd.visfields
 * @since       1.5
 */
class Visformfields extends CMSPlugin implements SubscriberInterface
{
    // load plugin language files
	protected $autoloadLanguage = true;

    public static function getSubscribedEvents(): array {
        return ['onEditorButtonsSetup' => 'onEditorButtonsSetup'];
    }

    public function onEditorButtonsSetup(EditorButtonsSetupEvent $event): void {
        $subject  = $event->getButtonsRegistry();
        $disabled = $event->getDisabledButtons();

        if (\in_array($this->_name, $disabled)) {
            return;
        }

        $this->loadLanguage();

        $button = $this->onDisplay($event->getEditorId());

        if ($button) {
            $subject->add($button);
        }
    }

	public function onDisplay($name) {
		$app = $this->getApplication();
		$input = $app->getInput();
		$o = $input->get('option');
		$v = $input->get('view');
		if ($o == 'com_visforms' && ($v == 'visform' || $v == 'vispdf')) {
			$fid = $input->getCmd('fid', 0);
			$id = $fid > 0 ? $fid : $input->getCmd('id', 0);
			/*
			 * Javascript to insert the link
			 * View element calls jSelectVisformsfield when an field is clicked
			 * jSelectVisformsfield creates the Placeholder for the field, sends it to the editor,
			 * and closes the select frame.
			 */
			$linkeditorname = '&amp;editor=' . $name;
			/*
			 * Use the built-in element view to select the field.
			 * Currently uses blank class.
			 */
			$link = 'index.php?option=com_visforms&view=visplaceholders&fid=' . $id . '&layout=modal&tmpl=component&'
				. Session::getFormToken() . '=1' . $linkeditorname;

            $button = new Button(
                $this->_name,
                [
                    'action'  => 'modal',
                    'link'    => $link,
                    'text'    => Text::_('PLG_VISFORMFIELDS_BUTTON_VISFORMFIELDS'),
                    'icon'    => 'file-add',
                    'iconSVG' => '<svg viewBox="0 0 32 32" width="24" height="24"><path d="M28 24v-4h-4v4h-4v4h4v4h4v-4h4v-4zM2 2h18v6h6v10h2v-10l-8-'
                        . '8h-20v32h18v-2h-16z"></path></svg>',
                    // This is whole Plugin name, it is needed for keeping backward compatibility
                    'name' => $this->_type . '_' . $this->_name,
                ]
            );
			return $button;
		}
	}
}
