<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Plugin\Privacy\Visforms\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactoryAwareTrait;
use Joomla\Component\Privacy\Administrator\Plugin\PrivacyPlugin;
use Joomla\CMS\Event\Privacy\ExportRequestEvent;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Event\Privacy\CollectCapabilitiesEvent;

/**
 * Privacy plugin managing Visforms data
 *
 * @since  3.9.0
 */
class Visforms extends PrivacyPlugin implements SubscriberInterface
{
    use MVCFactoryAwareTrait;

    public static function getSubscribedEvents(): array
    {
        return [
            'onPrivacyExportRequest' => 'onPrivacyExportRequest',
            'onPrivacyCollectAdminCapabilities' => 'onPrivacyCollectAdminCapabilities',
        ];
    }
	public function __construct(DispatcherInterface $subject, array $config = array()) {
		parent::__construct($subject, $config);
	}

    public function onPrivacyExportRequest(ExportRequestEvent $event): void {
        $user = $event->getUser();
        $request = $event->getRequest();
		if (!$user && !$request->email) {
			return;
		}
		$domains = array();
		$domain = $this->createDomain('user_visforms', 'joomla_user_visforms_data');
		$domains[] = $domain;
		//ToDo Replace F1 with actual field label
		$tablelist = $this->getPrefixFreeDataTableList();
		if (empty($tablelist)) {
			return;
		}
		$db = $this->getDatabase();
		foreach ($tablelist as $table) {
			$query = $db->createQuery()
				->select('*')
				->from($db->quoteName($table))
				->order($db->quoteName('created') . ' ASC')
				->where($db->quoteName('created_by') . ' = ' . (int) $user->id);
			try {
				$items = $db->setQuery($query)->loadObjectList();
			}
			catch (\RuntimeException $e) {
				continue;
			}
			if (empty($items)) {
				continue;
			}
			foreach ($items as $item) {
				$domain->addItem($this->createItemFromArray((array) $item));
			}
			// no custom fields in Visforms
			// $domains[] = $this->createCustomFieldsDomain('com_visforms.data', $items);
		}
        $event->addResult($domains);
	}

	private function getLowerCaseTableList() {
		$tablesAllowed = $this->getDatabase()->getTableList();
		if (!empty($tablesAllowed)) {
			return array_map('strtolower', $tablesAllowed);
		}
		else {
			return false;
		}
	}

	private function getPrefixFreeDataTableList() {
		$prefixFreeTableList = array();
		$forms = $this->getForms();
		if (empty($forms)) {
			return $prefixFreeTableList;
		}
		$tableList = $this->getLowerCaseTableList();
		if (empty($tableList)) {
			return $prefixFreeTableList;
		}
		$db = $this->getDatabase();
		foreach ($forms as $form) {
			$tnfulls = array(strtolower($db->getPrefix() . "visforms_" . $form->id), strtolower($db->getPrefix() . "visforms_" . $form->id . "_save"));
			foreach ($tnfulls as $tnfull) {
				if (in_array($tnfull, $tableList)) {
					$prefixFreeTableList[] = str_replace(strtolower($db->getPrefix()), "#__", $tnfull);
				}
			}
		}
		return $prefixFreeTableList;
	}

	private function getForms() {
        $db = $this->getDatabase();
		$query = $db->createQuery();
		$query->select('*')
			->from($db->qn('#__visforms'));
		try {
			$db->setQuery($query);
			return $db->loadObjectList();
		}
		catch (\RuntimeException $e) {
			return false;
		}
	}

	// Display Privacy Hints in Administration
	public function onPrivacyCollectAdminCapabilities(CollectCapabilitiesEvent $event): void {
		$this->loadLanguage();
		$result = $event->getArgument('result');
        $result[]  = array(
			Text::_('COM_VISFORMS_PRIVACY') => array(
				Text::_('COM_VISFORMS_PRIVACY_INFORMATION'),
			),
			Text::_('PLG_VISFORMS_SPAMBOTCHECK') => array(
				Text::_('PLG_VISFORMS_SPAMBOTCHECK_PRIVACY_INFORMATION'),
			)
		);
		$event->setArgument('result', $result);
	}
}
