<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Plugin\Visforms\Vfcustomplugin\Extension;

// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\MVC\Factory\MVCFactoryAwareTrait;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Version;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Language\LanguageHelper;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;
use Joomla\Filesystem\Path;
use Joomla\CMS\Log\Log;
use Joomla\CMS\Date\Date;
use Joomla\Component\Menus\Administrator\Helper\MenusHelper;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Visolutions\Component\Visforms\Administrator\Event\Visforms\VisformsAfterBatchCopyFormEvent;
use Visolutions\Component\Visforms\Administrator\Event\Visforms\VisformsPrepareJFormEvent;
use Visolutions\Component\Visforms\Administrator\Event\Visforms\VisformsSaveJFormExtraDataEvent;
use Visolutions\Component\Visforms\Administrator\Model\VisformModel;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Router\Route;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAddWebAssetsEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterConfirmDoiEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterCustomtextPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterEditFormSaveErrorEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterEditFormSaveEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterFormSaveErrorEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterFormSaveEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsAfterHtmlPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeConfirmDoiEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeEditSaveEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeEmailPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeFormSaveAfterUploadEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeFormSaveEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeHtmlPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsBeforeSuccessActionEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsEditFormPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsEmailPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsFormPrepareEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsMessageTextEvent;
use Joomla\CMS\Event\Model;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsPrepareDoiMailTextEvent;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsSpambotCheckEvent;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

// example code: the VisformsHelper provides useful functions that Visforms is using itself

//
// coding template covering all 30 existing visforms event handler
//

//
// if you create a custom plugin using this coding template
// make sure, that you remove/comment all handler functions, which you do not use in your code
// otherwise these unused handlers will always be triggered
//

class Vfcustomplugin extends CMSPlugin implements SubscriberInterface {
    use MVCFactoryAwareTrait;
    use DatabaseAwareTrait;
	// example code: a class member variable that is used later on
	// public $input = '';
	private string $loggerName;

	public function __construct(DispatcherInterface $subject, array $config) {
		parent::__construct($subject, $config);
		$this->initializeLogger($config);
		// example code: set Joomla input object to class variable
		// $this->input = Factory::getApplication()->getInput();
		// example code: get parameter id from the Joomla input object from class variable
		// $id = $this->input->getInt('id', 0);
	}

    public static function getSubscribedEvents(): array {
        return [
            'onVisformsEmailPrepare' => 'onVisformsEmailPrepare',
            'onVisformsBeforeEmailPrepare' => 'onVisformsBeforeEmailPrepare',
            'onVisformsBeforeFormSave' => 'onVisformsBeforeFormSave',
            'onVisformsBeforeFormSaveAfterUpload' => 'onVisformsBeforeFormSaveAfterUpload',
            'onVisformsAfterFormSave' => 'onVisformsAfterFormSave',
            'onVisformsAfterFormSaveError' => 'onVisformsAfterFormSaveError',
            'onVisformsBeforeSuccessAction' => 'onVisformsBeforeSuccessAction',
            'onVisformsMessageText' => 'onVisformsMessageText',
            'onVisformsAfterEditFormSave' => 'onVisformsAfterEditFormSave',
            'onVisformsAfterEditFormSaveError' => 'onVisformsAfterEditFormSaveError',
            'onVisformsEditFormPrepare' => 'onVisformsEditFormPrepare',
            'onVisformsBeforeEditSave' => 'onVisformsBeforeEditSave',
            'onVisformsPrepareJForm' => 'onVisformsPrepareJForm',
            'onVisformsBeforeJFormSave' => 'onVisformsBeforeJFormSave',
            'onVisformsAfterJFormSave' => 'onVisformsAfterJFormSave',
            'onVisformsBeforeJFormDelete' => 'onVisformsBeforeJFormDelete',
            'onVisformsAfterJFormDelete' => 'onVisformsAfterJFormDelete',
            'onVisformsJFormChangeState' => 'onVisformsJFormChangeState',
            'onVisformsSaveJFormExtraData' => 'onVisformsSaveJFormExtraData',
            'onVisformsAfterBatchCopyForm' => 'onVisformsAfterBatchCopyForm',
            'onVisformsdataAfterJFormSave' => 'onVisformsdataAfterJFormSave',
            'onVisformsdataAfterJFormDelete' => 'onVisformsdataAfterJFormDelete',
            'onVisformsdataJFormChangeState' => 'onVisformsdataJFormChangeState',
            'onVisformsFormPrepare' => 'onVisformsFormPrepare',
            'onVisformsAfterCustomtextPrepare' => 'onVisformsAfterCustomtextPrepare',
            'onVisformsPrepareDoiMailText' => 'onVisformsPrepareDoiMailText',
            'onVisformsAddWebAssets' => 'onVisformsAddWebAssets',
            'onVisformsSpambotCheck' => 'onVisformsSpambotCheck',
            'onVisfieldBeforeCreate' => 'onVisfieldBeforeCreate',
            'onVisformsBeforeHtmlPrepare' => 'onVisformsBeforeHtmlPrepare',
            'onVisformsAfterHtmlPrepare' => 'onVisformsAfterHtmlPrepare',
            'onVisformsBeforeConfirmDoi' => 'onVisformsBeforeConfirmDoi',
            'onVisformsAfterConfirmDoi' => 'onVisformsAfterConfirmDoi',
        ];
    }

	// common for both: form submit and data edit

    public function onVisformsEmailPrepare(VisformsEmailPrepareEvent $event): void {
		// context = 'com_visforms.form.resultmail'
		// context = 'com_visforms.form.receiptmail'
		// triggered in VisformsModel after the mail object is instantiated and directly before the mail is sent:
		// can be used to modify the mail object: mail object is instantiated and all properties are set and can be modified

        $context = $event->getContext();
        $mail = $event->getMail();
        $form = $event->getForm();

		// example code: simply change email text
		// $mail->Body = '<p>My new admin email body.</p>';

		// example code:  add user selected mail recipients to admin email
		// selected by multi-selection form field 'email-select'

		return;
	}

    public function onVisformsBeforeEmailPrepare(VisformsBeforeEmailPrepareEvent $event): void {
	    // context = 'com_visforms.form.resultmail'
	    // context = 'com_visforms.form.receiptmail'
	    // triggered in VisformsModel before the mail object is instantiated:
	    // can be used to modify the form object (i.e. to stop sending the mail or change addresses)

        $context = $event->getContext();
        $form = $event->getForm();
    }

	// form submit specific

    public function onVisformsBeforeFormSave(VisformsBeforeFormSaveEvent $event): void {
        // context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();

		// example code: exit, if we are in administration
		/*$app = $this->getApplication();
		if ($app->isClient('administrator')) {
			return;
		}*/

		// $this->onVisformsBeforeFormSave_preventNonLoggedInUser($context, $form, $fields);
		// $this->onVisformsBeforeFormSave_SendMails($context, $form, $fields);

        // Set Event result

        // true = continue visforms action
        // $event->addResult(true)

        // false = aboard visforms action
        // $event->addResult(false);
	}

	public function onVisformsBeforeFormSaveAfterUpload(VisformsBeforeFormSaveAfterUploadEvent $event): void {
		// context = 'com_visforms.form.form' (form was sent)
		// context = 'com_visforms.form.edit' (form data was edited)

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();
	}

    public function onVisformsAfterFormSave(VisformsAfterFormSaveEvent $event): void {
        // context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();
    }

    public function onVisformsAfterFormSaveError(VisformsAfterFormSaveErrorEvent $event): void {
        // context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();
	}

    public function onVisformsBeforeSuccessAction(VisformsBeforeSuccessActionEvent $event): void {

	    // override properties in $form (i.e. redirect url, successmessage)
        // context = 'com_visforms.form'
		// triggered in VisformsController before form result text is parameter processed and before running of all content plugins

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();

		// example code: simply change the result text before all parameters are processed
		// $form->textresult = "<div class=\"my-text-result-class\">Mein neuer Ergebnis-Text.</div>";

	}

	public function onVisformsMessageText(VisformsMessageTextEvent $event): void {
		// context = 'com_visforms.form'
		// triggered in VisformsController after form result text is parameter processed and before running of all content plugins
        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();
        $msg = $event->getMessage();
		// example code: simply change the result text after all parameters are processed
		// $msg = preg_replace('#search-me#', '${0} and replace-me', $msg);

        // set modified msg in event
        $event->setArgument('msg', $msg);
	}

	// data edit specific

    public function onVisformsAfterEditFormSave(VisformsAfterEditFormSaveEvent $event): void {
        // after saving edit form results
        // context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();
	}

    public function onVisformsAfterEditFormSaveError(VisformsAfterEditFormSaveErrorEvent $event): void {
        // clean up, saving edit form results in an error (i.e. delete uploaded files)
        // context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();
	}

	public function onVisformsEditFormPrepare(VisformsEditFormPrepareEvent $event): void {
		// context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $menu_params = $event->getMenuParams();
	}

	public function onVisformsBeforeEditSave(VisformsBeforeEditSaveEvent $event): void {
		// context = 'com_visforms.form'

        $context = $event->getContext();
        $form = $event->getForm();
        $fields = $event->getFields();

        // Set Event result

        // true = continue visforms action
        // $event->addResult(true)

        // false = aboard visforms action
        // $event->addResult(false);
	}

	// JForm events: Visforms
    // Triggered in Administration only, Overrides for the Joomla default events

    public function onVisformsPrepareJForm(VisformsPrepareJFormEvent $event): void {
        $form = $event->getForm();
	}

	public function onVisformsBeforeJFormSave(Model\BeforeSaveEvent $event): void {
        $context = $event->getContext();
        $table = $event->getItem();
        $isNew = $event->getIsNew();
        $data = $event->getData();
	}

	public function onVisformsAfterJFormSave(Model\AfterSaveEvent $event): void {
		// context = 'com_visforms.visfield'
		// context = 'com_visforms.visform'

        $context = $event->getContext();
        $table = $event->getItem();
        $isNew = $event->getIsNew();
        $data = $event->getData();

		// example code: reaction only to selected contexts
		/*if (($context === 'com_visforms.visfield') || ($context === 'com_visforms.visform')) {
			return;
		}*/

	}

	public function onVisformsBeforeJFormDelete(Model\BeforeDeleteEvent $event): void {
		// context = 'com_visforms.visfield'
		// context = 'com_visforms.visform'

        $context = $event->getContext();
        $table = $event->getItem();

		// example code: reaction only when deleting a field
		/*if ($context == 'com_visforms.visfield') {
			return;
		}*/

		// example code: skip plugin if we are deleting something other than a visforms form or field
		/*if (($context != 'com_visforms.visfield') && ($context != 'com_visforms.visform')) {
			return;
		}*/

		// example code: we ware deleting a form
		// delete fields in visfields table
		// delete datatable if table exists
		// delete pdfs in vispdf table
		/*if ($context == 'com_visforms.visform') {
			return;
		}*/
	}

	public function onVisformsAfterJFormDelete(Model\AfterDeleteEvent $event): void {
		// context = 'com_visforms.visfield'
		// context = 'com_visforms.visform'

        $context = $event->getContext();
        $table = $event->getItem();

		// example code: reaction only to selected contexts
		/*if (($context === 'com_visforms.visform') || ($context === 'com_visforms.visfield')) {
			return;
		}*/
	}

    public function onVisformsJFormChangeState(Model\AfterChangeStateEvent $event): void {
        // context = 'com_visforms.visfield'
        // context = 'com_visforms.visform'

	    $context = $event->getContext();
        $value = $event->getValue();
        $pks = $event->getPks();

		// example code: reaction only to selected context
		/*if ($context === 'com_visforms.visform') {
			return;
		}*/

		// example code: reaction only to selected context
		/*if ($context === 'com_visforms.visfield') {
			return;
		}*/
	}

	public function onVisformsSaveJFormExtraData(VisformsSaveJFormExtraDataEvent $event): void {
        $data = $event->getData();
        $fid = $event->getFid();
        $isNew = $event->getIsNew();
	}

    public function onVisformsAfterBatchCopyForm(VisformsAfterBatchCopyFormEvent $event) : void {
        $pk = $event->getPk();
        $newId = $event->getNewId();
    }

    // JForm events: Visforms data

	public function onVisformsdataAfterJFormSave(Model\AfterSaveEvent $event): void {
		// context = 'com_visforms.visdata'
		// event is triggered from administration and from site

        $context = $event->getContext();
        $table = $event->getItem();
        $isNew = $event->getIsNew();
        $data = $event->getData();

		// example code: we only want to react if the event comes from administration, because the site is handled by onVisformsAfterEditFormSave
		/*$app = $this->getApplication();
		if ($app->isClient('site')) {
			return;
		}*/

		// example code: reaction only to selected context
		/*if ($context === 'com_visforms.visdata') {
			return;
		}*/
	}

	public function onVisformsdataAfterJFormDelete(Model\AfterDeleteEvent $event): void {
		// context = 'com_visforms.visdata'
        $context = $event->getContext();
        $table = $event->getItem();
	}

    public function onVisformsdataJFormChangeState(Model\AfterChangeStateEvent $event): void {
        // context = 'com_visforms.visdata'

	    $context = $event->getContext();
        $pks = $event->getPks();
        $value = $event->getValue();

		// example code: reaction only to selected context
		/*if ($context === 'com_visforms.visdata') {
			return;
		}*/
	}

	// mixed singles

    public function onVisformsFormPrepare(VisformsFormPrepareEvent $event): void {
        // context = 'com_visforms.form'
        // context = 'mod_visforms.form'
        // context = 'plg_vfformview.form'
        // the event is form-based and is fired once for the form
        // triggered almost immediately before the layout file (component/module/plugin) is loaded


        $context = $event->getContext();
        $form = $event->getForm();
        $menu_params = $event->getMenuParams();

		// $this->onVisformsFormPrepare_preventNonLoggedInUser($context, $form, $menu_params);
		// $this->onVisformsFormPrepare_SendMails($context, $form, $menu_params);
	}

	public function onVisformsAfterCustomtextPrepare(VisformsAfterCustomtextPrepareEvent $event): void {
		// context = 'com_visforms.field'
		// can be used to modify the visfield custom text property late, after all visforms specific processing is complete
        $context = $event->getContext();
        $layout = $event->getLayout();
        $html = $event->getHtml();

        // set modified html in event
        $event->setArgument('html', $html);
	}

    public function onVisformsPrepareDoiMailText(VisformsPrepareDoiMailTextEvent $event): void {
        // context = 'com_visforms.form.receiptmail'
		// used to replace custom placeholder for Double-Opt-In Link

        $context = $event->getContext();
        $text = $event->getText();
        $form = $event->getForm();

        // set modified Text in event.
        $event->setArgument('text', $text);
	}

    public function onVisformsAddWebAssets(VisformsAddWebAssetsEvent $event): void {
		// context = 'com_visforms.form.form' (component via menu, modul or plugin)
		// context = 'com_visforms.form.message' (component)
		// context = 'com_visforms.form.data' (only available with component)
		// context = 'com_visforms.form.datas' (component, plugin)
		// context = 'com_visforms.form.edit' (component)
		// context = 'com_visforms.form.edit_link' (component via menu, modul or plugin)

        $context = $event->getContext();
        $fid = $event->getFid();

		// component via menu, modul or plugin means:
		// The form is displayed with the help of a menu item 'Visforms Form' or a module of the type 'Visforms' or the 'Content Plugin Visforms Form'.
		//
		// add custom JavaScript and CSS to Visforms depending on view type (menu, modul, plugin) and action (form, message, data, datas, edit, edit_link)
	}

    public function onVisformsSpambotCheck(VisformsSpambotCheckEvent $event) : void {
        // context = 'com_visforms.visformedit'
        // context = 'com_visforms.visform'

        $context = $event->getContext();

		// stop event propagation
		// $event->stopPropagation();

        // Set Event result

        // false = continue visforms action
        // $event->addResult(false);

        // true  = aboard visforms action
        //$event->addResult(true);
	}

	// mixed pairs: before, after

	public function onVisfieldBeforeCreate(VisfieldBeforeCreateEvent $event): void {
		// context = 'com_visforms.field'
        //$context, &$field, &$form

        $context = $event->getContext();
        $form = $event->getForm();
        $field = $event->getField();
	}

	public function onVisformsBeforeHtmlPrepare(VisformsBeforeHtmlPrepareEvent $event): void {
		// context = 'com_visforms.field'
		// the event is field specific and is fired per field
		// it allows changes on field properties before control html is created

        $context = $event->getContext();
        $layout = $event->getLayout();
        $field = $event->getField();
	}

	public function onVisformsAfterHtmlPrepare(VisformsAfterHtmlPrepareEvent $event): void {
		// context = 'com_visforms.field'
		// allow changes on field properties after control html is created

        $context = $event->getContext();
        $layout = $event->getLayout();
        $html = $event->getHtml();
        $field = $event->getField();

        // set modified html in event
        $event->setArgument('html', $html);

	}

	public function onVisformsBeforeConfirmDoi(VisformsBeforeConfirmDoiEvent $event): void {
		// context = 'com_visforms'
		// use in double-opt-in confirmation process
		// implement an individual action before the confirmation is validated and database changes are made

        $context = $event->getContext();
        $fid = $event->getFid();
        $recordId = $event->getRecordId();
	}

	public function onVisformsAfterConfirmDoi(VisformsAfterConfirmDoiEvent $event): void {
		// context = 'com_visforms'
		// used to implement an individual action performed after successful double-opt-in

        $context = $event->getContext();
        $fid = $event->getFid();
        $recordId = $event->getRecordId();
	}

	// not an event
	protected function removeUploadedFiles($context, $form, $fields): bool {
		if ($context != 'com_visforms.form') {
			return true;
		}

		if ($this->getApplication()->isClient('administrator')) {
			return true;
		}

		return true;
	}

	// implementation: example functions

	private function onVisformsFormPrepare_preventNonLoggedInUser($context, $form, $menu_params): bool {
		// documentation example code: add a custom submit handler
		// here: prevent submitting by users who are not logged in
		// first possibility: the message appears before the form is sent
		// to be called from the handler onVisformsFormPrepare()

		// skip plugin if context is wrong
		$allowedContexts = array('com_visforms.form', 'mod_visforms.form', 'plg_vfformview.form');
		if (!in_array($context, $allowedContexts)) {
			return true;
		}
		$app = $this->getApplication();
		// only perform action, if we are in front end
		if ($app->isClient('administrator')) {
			return true;
		}
		// if $form->parentFormId is not set: Visforms or 'Content Plugin Form View' version is too old
		if (!isset($form->parentFormId)) {
			return true;
		}
		// get value of id attribute of the form which is going to be displayed
		$parentFormId = $form->parentFormId;
		// START: add custom submit handler function to the form
		$user = Factory::getApplication()->getIdentity();
		if (!$user->id) {
			$script = 'jQuery(document).ready(function () {
	            //add custom submit action function to form
	            window["' . $parentFormId . 'SubmitAction"] = function (form) {
	                // return false: to prevent form from being submitted
	                alert("Please log in first");
	                return false;
	                // your alternative code in here
	                // return true: your submit-handler performs another action and form should be send
	                // return true;
	            };
	        });';
			$wa = $app->getDocument()->getWebAssetManager();
			$wa->addInlineScript($script);
		}
		// END: add custom submit handler function to the form

		return true;
	}

	private function onVisformsBeforeFormSave_preventNonLoggedInUser($context, $form, $fields): bool {
		// documentation example code: add a custom submit handler
		// here: prevent submitting by users who are not logged in
		// second possibility: the message appears after submitting the form
		// to be called from the handler onVisformsBeforeFormSave()

		// skip plugin if context is wrong
		$allowedContexts = array('com_visforms.form', 'mod_visforms.form', 'plg_vfformview.form');
		if (!in_array($context, $allowedContexts)) {
			return true;
		}
		$app = $this->getApplication();
		// only perform action, if we are in front end
		if ($app->isClient('administrator')) {
			return true;
		}
		// YOUR CODE IN HERE
		$user = Factory::getApplication()->getIdentity();
		if (!$user->id) {
			$message = 'Please log in first';
			$input = $app->getInput();
			$return = $input->post->get('return', null, 'cmd');
			$url = (!empty($return)) ? base64_decode(strtr($return, '-_,', '+/=')) :  'index.php';
			$app->enqueueMessage($message, 'warning');
			$app->redirect(Route::_($url, false));
			$app->close();
		}

		return true;
	}

	private function onVisformsFormPrepare_SendMails($context, $form, $menu_params): bool {
		// documentation example code:  hidden field and set its value dynamically
		// to be called from the handler onVisformsFormPrepare()

		// skip plugin if context is wrong
		$allowedContexts = array('com_visforms.form', 'mod_visforms.form', 'plg_vfformview.form');
		if (!in_array($context, $allowedContexts)) {
			return true;
		}
		$app = $this->getApplication();
		// only perform action, if we are in front end
		if ($app->isClient('administrator')) {
			return true;
		}
		// if $form->parentFormId is not set: Visforms or 'Content Plugin Form View' version is too old
		if (!isset($form->parentFormId)) {
			return true;
		}
		// get value of id attribute of the form which is going to be displayed
		$parentFormId = $form->parentFormId;
		// START: add custom submit handler function to the form
		// todo: clarify why using the expression "&lt;input/>" doesn't work and the input-element does not get created
		$script = 'jQuery(document).ready(function () {
			console.log("onVisformsFormPrepare_SendMails");
			jQuery("&lt;input/>",
		    {"id" : "'. $parentFormId .'myhiddenfield", 
		    "type" : "hidden", 
		    "value" : "0", 
		    "name" : "myhiddenfield"}).appendTo("#'. $parentFormId .'");
		    console.log("onVisformsFormPrepare_SendMails");
		    window["'. $parentFormId .'SubmitAction"] = function (form) {
	            if (jQuery(form.submitButton).hasClass("formready")) {
	                jQuery("#'. $parentFormId .'myhiddenfield").val("1");
	            };
	            return true;
	        };
		});';
		$script = 'jQuery(document).ready(function () {
			let el = document.createElement("input");
			el.id = "'. $parentFormId .'myhiddenfield"
			el.type = "hidden"; 
		    el.value = "0"; 
		    el.name = "myhiddenfield";
			jQuery("#'. $parentFormId .'").append(el);
		    window["'. $parentFormId .'SubmitAction"] = function (form) {
	            if (jQuery(form.submitButton).hasClass("formready")) {
	                jQuery("#'. $parentFormId .'myhiddenfield").val("1");
	            };
	            return true;
	        };
		});';
		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$wa->addInlineScript($script);
		// END: add custom submit handler function to the form

		return true;

	}

	private function onVisformsBeforeFormSave_SendMails($context, $form, $fields): bool {
		// documentation example code:  hidden field and set its value dynamically
		// to be called from the handler onVisformsBeforeFormSave()

		// skip plugin if context is wrong
		$allowedContexts = array('com_visforms.form', 'mod_visforms.form', 'plg_vfformview.form');
		if (!in_array($context, $allowedContexts)) {
			return true;
		}
		$app = $this->getApplication();
		// only perform action, if we are in front end
		if ($app->isClient('administrator')) {
			return true;
		}
		// YOUR CODE IN HERE
		$sendMail = $app->getInput()->post->get('myhiddenfield', "0", 'STRING');
		if (!empty($sendMail)) {
			// enable sending the admin email
			$form->emailresult = 1;
			// enable sending the user mail
			$form->emailreceipt = 1;
			return true;
		}

		return true;
	}

	private function onVisformsBeforeEmailPrepare_changeNumberFormat($context, $form): bool {
		// context = 'com_visforms.form.resultmail'
		// context = 'com_visforms.form.receiptmail'
		// triggered in VisformsModel before the mail object is instantiated:
		// can be used to modify the form object (i.e. to stop sending the mail or change addresses)

		if($form->id == 2) {
			$field = $this->getFieldByID($form, 84);
			// german notation without thousands separator
			$field->dbValue = number_format($field->dbValue, 2, '.', '') . ' €';
		}

		return true;
	}

	// implementation: helper functions

	private function getField(&$form, string $name): null | object {
		if (is_array($form->fields)) {
			foreach ($form->fields as $field) {
				$fieldName = (!empty($form->context)) ? str_replace($form->context, '', $field->name) : $field->name;
				if ($name === $fieldName) {
					return $field;
				}
			}
		}
		return null;
	}

	private function getFieldValue(&$form, string $name): string {
		$field = $this->getField($form, $name);
		if (isset($field)) {
			return is_null($field->dbValue) ? '' : $field->dbValue;
		}
		return '';
	}

	private function getFieldByID(&$form, string $ID): null | object {
		if (is_array($form->fields)) {
			foreach ($form->fields as $field) {
				$fieldID = (!empty($form->context)) ? str_replace($form->context, '', $field->id) : $field->id;
				if ($ID === $fieldID) {
					return $field;
				}
			}
		}
		return null;
	}

	private function getFieldValueByID(&$form, string $ID): string {
		$field = $this->getFieldByID($form, $ID);
		if (isset($field)) {
			return is_null($field->dbValue) ? '' : $field->dbValue;
		}
		return '';
	}

	// implementation: logging

	private function initializeLogger($config) {
		$this->loggerName               = $config['type'] . '-' . $config['name'];
		$options['format']              = "{CODE}\t{MESSAGE}";
		$options['text_entry_format']   = "{PRIORITY}\t{MESSAGE}";
		$options['text_file']           = $config['type'] . '_' . $config['name'] . '.php';
		try {
			Log::addLogger($options, Log::ALL, array($this->loggerName, 'jerror'));
		}
		catch (\RuntimeException $e) {}
	}

	private function addLogEntry($message, $code = Log::ERROR) {
		try {
			Log::add($message, $code, $this->loggerName);
		}
		catch (\RuntimeException $exception) {
			// prevent routine from failing due to problems with logger
		}
	}
}