<?php
/**
 * @version        $Id: plgCkformsSpamCheck.php
 * @package        visforms SpamCheck - check for possible spambots during register and login
 * @author         vi-solutions, Aicha Vack the plugin is build on user-plugin spambotchek, originally written by Robert Kuster
 * @link         https://www.vi-solutions.de
 * @copyright      Copyright (C) 2013 vi-solutions. All rights reserved.
 * @license        GNU/GPL, see LICENSE.txt
 */

namespace Visolutions\Plugin\Visforms\Spambotcheck\Extension;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Factory\MVCFactoryAwareTrait;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Joomla\Registry\Registry;
use Joomla\Event\DispatcherInterface;
use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisformsSpambotCheckEvent;
use Visolutions\Plugin\Visforms\Spambotcheck\Helper\SpambotCheckProvider;

class Spambotcheck extends CMSPlugin implements SubscriberInterface
{
    use MVCFactoryAwareTrait;
    use DatabaseAwareTrait;
	private $model;
	private $id;
	private $input;
    protected $autoloadLanguage = true;

	public function __construct(DispatcherInterface $subject, array $config) {
		parent::__construct($subject, $config);
		$this->input = Factory::getApplication()->getInput();
		$this->id = $this->input->getInt('id', 0);
	}

    public static function getSubscribedEvents(): array {
        return [
            'onVisformsSpambotCheck' => 'onVisformsSpambotCheck',
        ];
    }

	public function onVisformsSpambotCheck(VisformsSpambotCheckEvent $event): void {
        $context = $event->getContext();
		$this->model = new VisformsModelSite(array('ignore_request' => true, 'id' => $this->id));
		$fields = $this->model->getItems();
		$form = $this->model->getForm();
		$user = Array();
		$user['email'] = "";
		//find the first e-mail field in form and consider it the recipient mail
		foreach ($fields as $value) {
			if (isset($value->typefield) && $value->typefield == "email") {
				$emailField = $value->name;
				if (isset($form->context)) {
					$emailField = $form->context . $emailField;
				}
				$user['email'] = $this->input->getString($emailField, '');
				break;
			}
		}

		$spamString = "";
		if (self::isSpammer($user, $spamString)) {
			if ($context == '') {
				//we come from an older version of the data edit extension
				//Throw a message for the spammer
				$app = Factory::getApplication();
				$app->enqueueMessage(sprintf(Text::_('PLG_VISFORMS_SPAMBOTCHECK_USER_LOGIN_SPAM_TXT')), "error");
			}
			//do nothing else
            $event->addResult(true);
			return;
		}
        $event->addResult(false);
	}


	 // check if the user specified is a spammer.
	function isSpammer($user, &$spamString) {
		$form = $this->model->getForm();
		if (!isset($form->spamprotection)) {
			return false;
		}
		$registry = new Registry;
		$params = $registry->loadString($form->spamprotection);
		$SpambotCheck = new SpambotCheckProvider($params, $user['email'], $_SERVER['REMOTE_ADDR'], "");
		$SpambotCheck->checkOwnListingsAndSpambotProvider();
		if ($SpambotCheck->identifierTag == false || strlen($SpambotCheck->identifierTag) === 0 || !str_contains($SpambotCheck->identifierTag, "SPAMBOT_TRUE")) {
			// not a spammer
			$spamString = "";
			return false;
		}
		// if we get here we have to deal with a spammer
		$spamString = $SpambotCheck->identifierTag;
		return true;
	}
}