<?php
/**
 * Visform view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace Visolutions\Component\Visforms\Administrator\View\Visform;

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\View\ItemViewBase;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

class HtmlView extends ItemViewBase {
    function __construct($config = array()) {
        parent::__construct($config);
        $this->editViewName = "visform";
        $this->controllerName = 'visform';
        $this->canSaveToCopy = true;
    }

    protected function setMembers() { }

    protected function getTitle() {
        $text = $this->isNew ? Text::_( 'COM_VISFORMS_FORM_NEW' ) : Text::_( 'COM_VISFORMS_FORM_EDIT' );
        return Text::_('COM_VISFORMS_FORM') . VisformsHelper::appendTitleAppendixFormat($text);
    }

    protected function setToolbar() {
    	if (!$this->checkedOut) {
	        ToolbarHelper::custom("$this->controllerName.fields",'list','list','COM_VISFORMS_FIELDS',false) ;
        }

        if ($this->form->getValue('saveresult') == '1') {
            ToolbarHelper::custom("$this->controllerName.datas",'database','database','COM_VISFORMS_DATAS',false) ;
        }

	    if (AefHelper::checkAEF()) {
		    ToolbarHelper::custom("$this->controllerName.pdfs",'file-2','file-2','COM_VISFORMS_PDFS',false) ;
	    }
    }

    protected function getFIdUrlQueryName() { return 'id'; }

    protected function addHeaderDeclarations() {
	    VisformsHelper::addCommonVisformsJS();
    }
}