<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Administrator\Helper\MediaHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class FileEntry extends VisfieldPlaceholderEntry {

	protected static $customParams = array(
	    'ORGNAME' => 'COM_VISFORMS_PLACEHOLDER_PARAM_ORGNAME',
		'PATH' => 'COM_VISFORMS_PLACEHOLDER_PARAM_LOCAL_PATH',
		'FULLPATH' => 'COM_VISFORMS_PLACEHOLDER_PARAM_FULL_PATH',
		'LINK'  => 'COM_VISFORMS_PLACEHOLDER_PARAM_LINK'
	);

	protected static $customSubscriptionParams = array (
		'ASIMAGE' => 'COM_VISFORMS_PLACEHOLDER_IMAGE_AS_IMAGE',
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_DIE'
	);

	public function getReplaceValue() {
        // if data is empty string,
        // check if this ist a 'DIE' parameter
        // return proper CSS class or replace the placeholder with nothing
		if (empty($this->rawData)) {
            if (!empty($this->param) && $this->param === 'DIE' && $this->hasSub) {
                return 'die';
            }
            // return empty string to remove the placeholder
			return '';
		}
		// rawData is not empty, remove DIE Placeholder
        if ($this->param === 'DIE') {
		    return '';
        }
		// form option 'do not store uploaded files' is enabled
		// some params cannot be used
		if (!empty($this->field->tmpUpload)) {
            switch ($this->param) {
                case 'PATH' :
                case 'FULLPATH' :
                case 'LINK' :
                case 'ASIMAGE' :
                    return '';
            }
        }
		if ($this->hasSub) {
			$customParams = array_merge(self::$customParams, self::$customSubscriptionParams, self::$labelParams);
		}
		else {
			$customParams = array_merge(self::$customParams, self::$labelParams);
		}
		if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
			$isImage = MediaHelper::isImage(HTMLHelper::_('visforms.getUploadFileName', $this->rawData));
			switch ($this->param) {
                case 'DISPLAYLABEL' :
                    return $this->field->label;
                case 'DISPLAYLABELPLUSSPACE' :
                    return $this->field->label . ' ';
				case 'ORGNAME' :
					return HTMLHelper::_('visforms.getFileOrgName', $this->rawData);
				case 'PATH' :
					return HTMLHelper::_('visforms.getUploadFilePath', $this->rawData);
				case 'FULLPATH' :
					return HTMLHelper::_('visforms.getUploadFileFullPath', $this->rawData);
				case 'LINK' :
					return HTMLHelper::_('visforms.getUploadFileLink', $this->rawData);
				case 'ASIMAGE' :
					if ($isImage && $this->hasSub) {
						return '<img src="' . Uri::root(true) . '/' . HTMLHelper::_('visforms.getUploadFilePath', $this->rawData) . '" />';
					}
				default:
					return HTMLHelper::_('visforms.getUploadFileName', $this->rawData);
			}
		}
		// default return is file name
		return HTMLHelper::_('visforms.getUploadFileName', $this->rawData);
	}
}