<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */

namespace Visolutions\Component\Visforms\Administrator\Visfield\Restriction;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\String\StringHelper;
use Joomla\Database\DatabaseInterface;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldRestriction;

class UsedInCal extends VisfieldRestriction {

	public function __construct($value, $id, $name, $fid = null) {
		$this->type = 'usedInCal';
		parent::__construct($value, $id, $name, $fid);
	}

	protected function addRestricts() {
		if (($this->value !== '') && (!empty($this->fid))) {
			$pattern = '/\[[A-Z0-9]{1}[A-Z0-9\-]*]/';
			if (preg_match_all($pattern, $this->value, $matches)) {
				$db = Factory::getContainer()->get(DatabaseInterface::class);
				$names = array();
				foreach ($matches[0] as $match) {
					$str = trim($match, '\[]');
					$names[] = $db->q(StringHelper::strtolower($str));
				}
				$names = implode(",", $names);

				$query = $db->createQuery();
				$query->select($db->qn('id'))
					->from($db->qn('#__visfields'))
					->where($db->qn('name') . " in (" . $names . ")")
					->where($db->qn('fid') . " = " . $this->fid);
				try {
					$db->setQuery($query);
					$fields = $db->loadColumn();
				}
				catch (\RuntimeException $e) {
					$test = true;
				}
			}
			if (!empty($fields)) {
				foreach ($fields as $field) {
					$restrict = array();
					$restrict['type'] = $this->type;
					$restrict['restrictedId'] = $field;
					$restrict['restrictorId'] = $this->id;
					$restrict['restrictorName'] = $this->name;
					$this->restricts[] = $restrict;
				}
			}
		}
	}
}