<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

// used from component list views 'default_datatable.php', 'default_datatableflat.php' and from data view plugin 'default.php'
if (!empty($displayData) && isset($displayData['form']) && isset($displayData['user']) && (isset($displayData['pdfTemplates']) || !empty($displayData['addCsv']))) {
    $form = $displayData['form'];
    $user = $displayData['user'];
    $displaypdfexportbutton = (!empty($form->displaypdfexportbutton_list)) ? $form->displaypdfexportbutton_list : false;
    if ($displaypdfexportbutton && isset($displayData['extension']) && $displayData['extension'] === 'vfdataview') {
        $displaypdfexportbutton = (!empty($form->displaypdfexportbutton_plg)) ? $form->displaypdfexportbutton_plg : false;
    }
    $options = array();
    if ((!empty($displaypdfexportbutton) && !empty($form->listPdfTemplate)) && isset($displayData['pdfTemplates'])) {
        $pdfTemplates = $displayData['pdfTemplates'];
        foreach ($form->listPdfTemplate as $listPdfTmplId) {
	        if (!VisformsHelper::checkPdfTmplIdValid($listPdfTmplId)) {
		        continue;
	        }
            // check user has permission to create a pdf of this template
            if ($user->authorise('core.create.pdf', 'com_visforms.visform.' . (int)$form->id . '.vispdf.' . (int) $listPdfTmplId) || $user->authorise('core.create.own.pdf', 'com_visforms.visform.' . (int)$form->id . '.vispdf.' . (int) $listPdfTmplId)) {
                $pdfDownloadlinkText = (!empty($text = VisformsHelper::getPdfDownlaodLinkTitle($listPdfTmplId, $pdfTemplates))) ? Text::sprintf('COM_VISFORMS_DOWNLOAD_AS_PDF_TEXT_FOR_NAMED_DOCUMENT', $text) : Text::_('COM_VISFORMS_DOWNLOAD_PDF');
                $options[] = '<option value="renderPdfList_'.$listPdfTmplId.'">' . $pdfDownloadlinkText . '</option>';
            }
        }
    }
    if (!empty($displayData['addCsv'])) {
        $options[] = '<option value="exportCsv">' . Text::_('COM_VISFORMS_EXPORT_TO_CSV') . '</option>';
    }
    if (!empty($options)) {
        HTMLHelper::_('visforms.loadDataTaskJs');
        $emptyOption = '<option value="" selected="selected">' . Text::_('COM_VISFORMS_SELECT_LIST_DOWNLOAD_DOCUMENT') . '</option>';
        $options = implode('', $options);
        $label = '<label for="select-list-pdf-download-list" class="visually-hidden sr-only uk-invisible select-list-pdf-download-lbl">'.Text::_('COM_VISFORMS_SELECT_LIST_DOWNLOAD_DOCUMENT_LABEL').'</label>';
        $list = $label . '<select name="select-list-pdf-download-list" class="form-select select-list-pdf-download" data-form-id="'.$form->id.'"data-list-base-url="'. Uri::base().'">'.  $emptyOption. $options . '</select>';
        echo $list;
    }
}