<?php
/**
 * Visforms field date business class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Site\Lib\Message\MinDateMessage;
use Visolutions\Component\Visforms\Site\Lib\Message\MaxDateMessage;
use Visolutions\Component\Visforms\Site\Lib\Message\MinAgeMessage;
use Visolutions\Component\Visforms\Site\Lib\Message\EqualToMessage;
use Visolutions\Component\Visforms\Site\Lib\Message\DefaultMessage;
use Visolutions\Component\Visforms\Administrator\Helper\SqlHelper;
use Visolutions\Component\Visforms\Site\Lib\Validation\MinDateValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\MaxDateValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\MinAgeValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\EqualToValidation;

class DateFieldBusiness extends TextFieldBusiness
{
	protected function validatePostValue(): void {
		// update $this->field with value from $this->fields
		$this->updateField();
		$valid = true;
		// validate value from sql (option toggle_value_from_sql = 1)
		// edit view: only if option sql_process_in_edit_view is 1
		if (!empty($this->field->toggle_value_from_sql)) {
			// Edit View option sql_process_in_edit_view = 0
			if (($this->isRedisplayEditTask && empty($this->field->sql_process_in_edit_view))) {
				// nothing to do
			}
			// do not validate the value in attribute_value for disabled fields, if attribute_value and configurationDefault are exactly identical
			else if ((!empty($this->field->isDisabled)) && ($this->field->attribute_value === $this->field->configurationDefault)) {
				// nothing to do
			}
			// Form View, always validate sql value
			else {
				$value = $this->field->attribute_value;
				try {
					$sqlHelper = new SqlHelper($this->field->sql, (isset($this->form->context) ? $this->form->context : ''));
					$sqlValue = $sqlHelper->getItemsFromSQL('loadResult');
				}
				catch (\Exception $e) {
					$sqlValue = '';
				}
				// validate that submitted values equals the value we expect, if we process the sql statement with all the submitted user inputs
				$validation = new EqualToValidation(array('value' => $value, 'cvalue' => $sqlValue));
				if (!$validation->validate()) {
					// invalid value
					$valid = false;
					// attach error to form
					$message = new DefaultMessage($this->field->label, $this->field->custom_php_error);
					$error = $message->getMessage();
					// attach error to form
					$this->setErrors($error);
				}
			}
		}
		// only to perform when the value is not empty
		if ($this->field->attribute_value != "") {
			// do not validate the value in attribute_value for disabled fields, if attribute_value and configurationDefault are exactly identical
			if ((!empty($this->field->isDisabled) && ($this->field->attribute_value === $this->field->configurationDefault))) {
				return;
			}
			if ((isset($this->field->mindate)) && ($this->field->mindate != '') && isset($this->field->dateFormatPhp)) {
			    $validation = new MinDateValidation(array('date' => $this->field->attribute_value, 'mindate' => $this->field->mindate, 'format' => $this->field->dateFormatPhp, 'mindateformat' => $this->field->dateFormatPhp));
				if (!$validation->validate()) {
					// invalid value
					$valid = false;
                    $message = new MinDateMessage($this->field->label, $this->field->custom_php_error, array('mindate' => $this->field->mindate));
                    $error = $message->getMessage();
					// attach error to form
					$this->setErrors($error);
				}
			}
			else if (isset($this->field->minvalidation_type) && (str_contains($this->field->minvalidation_type, '#field'))) {
				// even if the min date comes from another field, it is not necessary to check if the value in that field is correct
                // each field is validated and handled individually
				$id = str_replace('#field', '', $this->field->minvalidation_type);
				// get the value of this field
				foreach ($this->fields as $field) {
					if ($field->id == $id) {
						$minDate = $field->attribute_value;
						$minDateFormat = $field->dateFormatPhp;
						break;
					}
				}
				// calculate the min date from value and shift
				if (!empty($minDate)) {
					$min = empty($this->field->dynamic_min_shift) ? $minDate : $minDate . ' ' . $this->field->dynamic_min_shift . ' days';
					$minDate = HTMLHelper::_('date', $min, $minDateFormat);
					$validation = new MinDateValidation(array('date' => $this->field->attribute_value, 'mindate' => $minDate, 'format' => $this->field->dateFormatPhp, 'mindateformat' => $minDateFormat));
					if (!$validation->validate()) {
						// invalid value
						$valid = false;
                        $message = new MinDateMessage($this->field->label, $this->field->custom_php_error, array('mindate' => HTMLHelper::_('date', $min, $this->field->dateFormatPhp)));
                        $error = $message->getMessage();
						// attach error to form
						$this->setErrors($error);
					}
				}

			}
			if ((isset($this->field->maxdate)) && ($this->field->maxdate != '') && isset($this->field->dateFormatPhp)) {
			    $validation = new MaxDateValidation(array('date' => $this->field->attribute_value, 'maxdate' => $this->field->maxdate, 'format' => $this->field->dateFormatPhp, 'maxdateformat' => $this->field->dateFormatPhp));
				if (!$validation->validate()) {
					// invalid value
					$valid = false;
                    $message = new MaxDateMessage($this->field->label, $this->field->custom_php_error, array('maxdate' => $this->field->maxdate));
                    $error = $message->getMessage();
					// attach error to form
					$this->setErrors($error);
				}
			}
			else if (isset($this->field->maxvalidation_type) && (str_contains($this->field->maxvalidation_type, '#field'))) {
				// even if the max date comes from another field, it is not necessary to check if the value in that field is correct,
                // each field is validated and handled individually
				$id = str_replace('#field', '', $this->field->maxvalidation_type);
				// get the value of this field
				foreach ($this->fields as $field) {
					if ($field->id == $id) {
						$maxDate = $field->attribute_value;
						$maxDateFormat = $field->dateFormatPhp;
						break;
					}
				}
				// calculate the max date from value and shift
				if (!empty($maxDate)) {
					$max = empty($this->field->dynamic_max_shift) ? $maxDate : $maxDate . ' + ' . $this->field->dynamic_max_shift . ' days';
					$maxDate = HTMLHelper::_('date', $max, $maxDateFormat);
					$validation = new MaxDateValidation(array('date' => $this->field->attribute_value, 'maxdate' => $maxDate, 'format' => $this->field->dateFormatPhp, 'maxdateformat' => $maxDateFormat));
                    if (!$validation->validate()) {
						// invalid value
						$valid = false;
                        $message = new MaxDateMessage($this->field->label, $this->field->custom_php_error, array('maxdate' => HTMLHelper::_('date', $max, $this->field->dateFormatPhp)));
                        $error = $message->getMessage();
						// attach error to form
						$this->setErrors($error);
					}
				}
			}
			if ((isset($this->field->minage)) && ($this->field->minage !== '') && (is_numeric($this->field->minage)) && isset($this->field->dateFormatPhp)) {
			    // Perform a Min age validation
                $validation = new MinAgeValidation(array('date' => $this->field->attribute_value, 'minage' => $this->field->minage, 'format' => $this->field->dateFormatPhp));
                if (!$validation->validate()) {
                    // invalid value
                    $valid = false;
                    $message = new MinAgeMessage($this->field->label, $this->field->custom_php_error, array('minage' => $this->field->minage));
                    $error = $message->getMessage();
                    // attach error to form
                    $this->setErrors($error);
                }
            }
			// perform equalTo validation
			if ((isset($this->field->validate_equalTo)) && ($this->field->validate_equalTo != '0')) {
				$value = $this->field->attribute_value;
				$id = str_replace("#field", "", $this->field->validate_equalTo);

				foreach ($this->fields as $equalToField) {
					if ($equalToField->id == $id) {
					    $validation = new EqualToValidation(array('value' => $value, 'cvalue' => $equalToField->attribute_value));
                        if (!$validation->validate()) {
							// invalid value
							$valid = false;
							// attach error to form
                            $message = new EqualToMessage($this->field->label, $this->field->custom_php_error, array('equalToLabel' => $equalToField->label));
                            $error = $message->getMessage();
							$this->setErrors($error);
							break;
						}
					}
				}
			}
			// validate unique field value in database
			$this->validateUniqueValue();
		}

		// at least one validation failed
		if (!$valid) {
			$this->field->isValid = false;
		}
	}
}