<?php
/**
 * Visforms Field Business Trait
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

trait FieldBusinessAwareTrait
{
    private $field;

    public function setBusinessField(\stdClass $field, \stdClass$form, array $fields): void {
        if (!(isset($field->typefield))) {
            return;
        }
        $class = '\Visolutions\Component\Visforms\Site\Lib\Business\\'. ucfirst($field->typefield) . 'FieldBusiness';
        $this->field = new $class($field, $form, $fields);
    }

    public function getBusinessField() {
        if ($this->field) {
            return $this->field;
        }
        throw new \UnexpectedValueException('BusinessField not set in ' . __CLASS__);
    }
}