<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class SelectsqlField extends SelectField
{
	public function getFieldAttributeArray() {
		$attributeArray = parent::getFieldAttributeArray();
		// individual classes, used in visforms.js in order to perform business logic on sql fields with reloaded options
		if (!empty($this->field->toggle_reload) && !empty($this->field->hideOnEmptyOptionList)) {
			$attributeArray['class'] .= " hideOnEmptyOptionList";
		}
		if (!empty($this->field->toggle_reload) && !empty($this->field->preSelectSolitaryOption)) {
			$attributeArray['class'] .= " preSelectedSolitaryOption";
		}
		if (!empty($this->field->toggle_reload) && !empty($this->field->preSelectSolitaryOption) && !empty($this->field->hideOnPreSelectedSolitaryOption)) {
			$attributeArray['class'] .= " hideOnPreSelectedSolitaryOption";
		}
		return $attributeArray;
	}
}