<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class SignatureField extends TextField
{
    protected $isMutable = false;

	public function __construct($field, $decorable, $attribute_type) {
		parent::__construct($field, false, 'text');
	}

    // create an array of HTML attributes for the HTML control
	public function getFieldAttributeArray() {
		$attributeArray = array('class' => 'signatureinput ');
		if (!empty($this->field->disableEnterKey)) {
			$attributeArray['class'] = 'noEnterSubmit ';
		}
		if (!empty($this->field->sig_in_footer)) {
			$attributeArray['class'] = 'noSummary ';
		}
		if (!isset($attributeArray['style'])) {
			$attributeArray['style'] = 'display: none;';
		}
		else {
			$attributeArray['style'] .= 'display: none;';
		}
        // HTML attributes are stored in xml-definition-fields with name that ends on _attribute_attributename (i.e. _attribute_checked)
        // names from xml field definition are used, to create the HTML attributes for the control
        // in the xml-definition file each form field is represented by a fieldset
        // in the xml-definition file each form field should have a xml-definition-field with a name that ends on _attribute_class
        // the following code converts the xml-definition-field-names to HTML attribute names and sets the values for the HTML attributes
		foreach ($this->field as $name => $value) {
			if (!is_array($value)) {
				if (str_contains($name, 'attribute_')) {
					if ($name == 'attribute_required') {
						$attributeArray['aria-required'] = 'true';
					}
					if ($value || $name == 'attribute_class' || ($name == 'attribute_value')) {
						$newname = str_replace('attribute_', "", $name);
						if ($newname == "class") {
							$value = $attributeArray[$newname] . " " . $value;
							$attributeArray[$newname] .= " " . $value;
						}
						else {
							$attributeArray[$newname] = $value;
						}
					}
				}
				if ($name == 'name') {
					$attributeArray['name'] = $value;
				}
				if ($name == 'id') {
					$value = 'field' . $value;
					$attributeArray['id'] = $value;
					$attributeArray['data-error-container-id'] = 'fc-tbx' . $value;
				}
				if (($name == 'isDisabled') && ($value == true)) {
					$attributeArray['class'] .= " ignore";
					$attributeArray['disabled'] = "disabled";
				}
				if (($name == 'isDisplayChanger') && ($value == true)) {
					$attributeArray['class'] .= " displayChanger";
				}
				if (($name == 'isValid') && ($value == false)) {
					$attributeArray['class'] .= " error";
				}
				$attributeArray['aria-labelledby'] = $this->field->name . 'lbl';
			}
		}
		return $attributeArray;
	}

    // bootstrap 5
    public function setControlBt5HtmlClasses($field) {
        return $field;
    }

	// uikit 3
	public function setUikit3ControlHtmlClasses($field) {
		return $field;
	}

	public function removeUnsupportedShowLabel($field) {
		unset($field->show_label);
		return $field;
	}
}