<?php
/**
 * Visforms HTML class for email field
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

class TelField extends TextField
{

    public function __construct($field, $decorable, $attribute_type) {
        $attribute_type = "tel";
        parent::__construct($field, $decorable, $attribute_type);
    }

    public function setFieldCustomValidateArray($field) {
        if (!isset($field->validateArray)) {
            $field->validateArray = array();
        }
        // custom validation for phone field
        $purge = '';
        if (!empty($field->phonevalidation)) {
            if (!empty($field->phonevalidation_include)) {
                $purge = ", purge:" . json_encode($field->phonevalidation_include);
                if (isset($field->attribute_required)) {
                    $field->validateArray['requiredwithinclude'] = "{requiredwithinclude:'" . $field->phonevalidation . "'".$purge."}";
                }
            }
            $field->validateArray['phonevalidation'] = "{phonevalidation:'" . $field->phonevalidation . "'".$purge."}";
        }
        return $field;
    }

}