<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Layout;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Visolutions\Component\Visforms\Site\Lib\Html\Control\ControlAwareTrait;
use Visolutions\Component\Visforms\Site\Lib\Html\Control\Decorator\Uikit3EditDecorator;

class Uikit3EditLayout extends Uikit3Layout
{
    use ControlAwareTrait;
	public function prepareHtml() {
		//attach error messages array for javascript validation to field
		$this->setFieldCustomErrorMessageArray();
		$this->cleanFieldProperties();
		$this->getFieldGroupUikitClasses();
		$this->setUikit3ControlHtmlClasses();
        $this->setToolTip();
		$this->setErrorId();
		//handle forbidden fields which cannot be edited
		$this->makeFieldUneditable();
		$this->setFieldAttributeArray();
		$this->setFieldValidateArray();
		$this->setFieldControlHtml();
		return $this->field;
	}

	protected function setUikit3ControlHtmlClasses() {
		// ToDo check if we need to set this in every field class, because there is no default...
		if (method_exists($this->fieldHtml, 'setUikit3ControlHtmlClasses')) {
			// set uikit class attributes on html control element (like uk-input, uk-select, visToolTip...)
			$this->field = $this->fieldHtml->setUikit3ControlHtmlClasses($this->field);
		}
	}

	protected function setFieldControlHtml() {
		// get Instance of field html control class according to field type and layout type
		// $ocontrol = VisformsHtmlControl::getInstance($this->fieldHtml, $this->type);
        $this->setControl($this->fieldHtml, $this->type);
        $ocontrol = $this->getControl();
		if (!(is_object($ocontrol))) {
			//throw an error
		}
		else {
			// instanciate decorators
			$control = new Uikit3EditDecorator($ocontrol);
		}
		// set field property
		$this->field->controlHtml = $control->getControlHtml();
	}
}