<?php
/**
 * Visforms Layout class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2025 vi-solutions
 * @since        Joomla 5
 */

namespace  Visolutions\Component\Visforms\Site\Lib\Layout;
use Joomla\CMS\Factory;

abstract class BaseLayout implements LayoutInterface {

    protected $showRequiredAsterix = 1;
    protected string $parentFormId = "";
    protected $defaultresponsive = 0;
    protected $requiredTextColor = '#bf1722';
    protected $requiredAsteriskColor = '#bf1722';
    protected $progressBarBgColor ='#f5f5f5';
    protected $badgeActiveBgColor = '#bf1722';
    protected $badgeActiveFontColor = '#ffffff';
    protected $badgeInActiveBgColor ='#999999';
    protected $badgeInActiveFontColor = '#ffffff';
    protected $badgeDoneBgColor = '#006611';
    protected $badgeDoneFontColor = '#ffffff';

    public function __construct($form) {
        // get layout options from form
        if (isset($form->requiredasterix)) {
            $this->showRequiredAsterix = $form->requiredasterix;
        }
        if (isset($form->parentFormId)) {
            $this->parentFormId = $form->parentFormId;
        }
        if (isset($form->defaultresponsive)) {
            $this->defaultresponsive = $form->defaultresponsive;
        }
        if (isset($form->required_text_color)) {
            $this->requiredTextColor = $form->required_text_color;
        }
        if (isset($form->required_asterix_color)) {
            $this->requiredAsteriskColor = $form->required_asterix_color;
        }
        if (!empty($form->usecustombadgecolor)) {
            if (isset($form->progressbarbgcolor)) {
                $this->progressBarBgColor = $form->progressbarbgcolor;
            }
            if (isset($form->badgeactivebgcolor)) {
                $this->badgeActiveBgColor = $form->badgeactivebgcolor;
            }
            if (isset($form->badgeactivefontcolor)) {
                $this->badgeActiveFontColor = $form->badgeactivefontcolor;
            }
            if (isset($form->badgeinactivebgcolor)) {
                $this->badgeInActiveBgColor = $form->badgeinactivebgcolor;
            }
            if (isset($form->badgeinactivefontcolor)) {
                $this->badgeInActiveFontColor = $form->badgeinactivefontcolor;
            }
            if (isset($form->badgedonebgcolor)) {
                $this->badgeDoneBgColor = $form->badgedonebgcolor;
            }
            if (isset($form->badgedonefontcolor)) {
                $this->badgeDoneFontColor = $form->badgedonefontcolor;
            }
        }
    }

    // Method to add layout specific custom css to the view.
    public function addCss() {
        $css = "";
        if ($this->showRequiredAsterix) {
            $css .= $this->getCustomRequiredCss();
        }
        if ($this->defaultresponsive) {
            $css .= $this->addDefaultResponsiveCss();
        }
        $css .= $this->addCustomCss();
        $css .= $this->addProgressCss();
        if ($css != "") {
            Factory::getApplication()->getDocument()->getWebAssetManager()->addInlineStyle($css);
        }
    }

    protected function addProgressCss() {
        $fullParent = 'form#' . $this->parentFormId;
        $css = <<<PROGRESSCSS
            $fullParent .visprogress {
                background-color: $this->progressBarBgColor;
            }
            $fullParent .visprogress .badge {
                color: $this->badgeInActiveFontColor;
                background-color: $this->badgeInActiveBgColor;
            }
            
            $fullParent .visform .visprogress .badge:empty {
                display: none;
            }
            
            $fullParent .visprogress .badge-important {
                color: $this->badgeActiveFontColor;;
                background-color: $this->badgeActiveBgColor;
            }
            
            $fullParent .visprogress .badge-success {
                color: $this->badgeDoneFontColor;
                background-color: $this->badgeDoneBgColor;
            }
        PROGRESSCSS;
        return $css;
    }

    abstract protected function addCustomCss();
    abstract protected function getCustomRequiredCss();
    abstract protected function addDefaultResponsiveCss();
}