<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2020 vi-solutions
 */

namespace Visolutions\Component\Visforms\Site\Log;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Log\Log;

trait VisformsLogTrait {

    protected $loggerName;

    protected function initializeLogger($loggerName, $logFileName = '') {
        $this->loggerName = $loggerName;
        $options['format'] = "{CODE}\t{MESSAGE}";
        $options['text_entry_format'] = "{DATE}\t{TIME}\t{PRIORITY}\t{MESSAGE}";
        // log file name may be empty:
        // try to search standard 'visforms' prefix and append an underscore to obey naming convention
        // logger name 'visformswffrm' --> 'visforms_wffrm'
        $options['text_file'] = $logFileName !== '' ? $logFileName : (str_replace('visforms', 'visforms_', $loggerName) . '.php');
        try {
            Log::addLogger($options, Log::ALL, array($this->loggerName, 'jerror'));
        }
        catch (\RuntimeException $e) {
        }
    }

    protected function addLogEntry($message, $code = Log::INFO) {
        try {
            Log::add($message, $code, $this->loggerName);
        }
        catch (\RuntimeException $exception) {
        }
    }
}