<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 5.3
 */

namespace Visolutions\Component\Visforms\Site\Model\Helper\Mail;

// no direct access
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

defined('_JEXEC') or die('Restricted access');

abstract class BaseMailDataHelper {

    protected $form;
    protected $type;
    protected $hasSub;

    public function __construct($form, $type) {
        $this->form = $form;
        $this->type = $type;
        $this->hasSub = AefHelper::checkAEF();
    }

    abstract public function getMailIncludeData();
}