<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 5.3
 */

namespace Visolutions\Component\Visforms\Site\Model\Helper\Mail;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;



class FormMailDataHelper extends BaseMailDataHelper {

    public function getMailIncludeData() {
        $visform = $this->form;
        $type = $this->type;
        $data = array();
        foreach ($visform->fields as $field) {
            $fieldValue = '';
            $label = (!empty($this->hasSub) && !empty($field->customlabelformail)) ? $field->customlabelformail : HTMLHelper::_('visforms.fixLinksInMail', $field->label);
            if (!empty($field->isButton)) {
                continue;
            }
            if ($field->typefield == 'pagebreak') {
                continue;
            }
            if ($field->typefield == 'fieldsep') {
                continue;
            }
            if (!empty($field->isDisabled)) {
                continue;
            }
            switch ($type) {
                case 'admin' :
                    if (empty($field->includeinresultmail)) {
                        continue 2;
                    }
                    break;
                default :
                    if (empty($field->includeinreceiptmail)) {
                        continue 2;
                    }
                    break;
            }
            if ($field->typefield == 'file' && isset($_FILES[$field->name]['name']) && $_FILES[$field->name]['name'] != '') {
                switch ($type) {
                    case 'admin' :
                        if ((!empty($visform->emailresultincfilepath)) && (isset($field->file['filelink']))) {
                            if (!empty($field->tmpUpload)) {
                                // upload is temporary only. Return org name of uploaded file
                                $fieldValue = (isset($field->file['name_org'])) ? $field->file['name_org'] : '';
                            }
                            else {
                                $fieldValue = $field->file['filelink'];
                            }
                        }
                        else {
                            $fieldValue = (isset($field->file['new_name'])) ? $field->file['new_name'] : '';
                        }
                        break;
                    default :
                        if ((!empty($visform->emailrecipientincfilepath)) && (isset($field->file['filelink']))) {
                            if (!empty($field->tmpUpload)) {
                                // upload is temporary only. Return org name of uploaded file
                                $fieldValue = (isset($field->file['name_org'])) ? $field->file['name_org'] : '';
                            }
                            else {
                                $fieldValue = $field->file['filelink'];
                            }
                        }
                        else {
                            $fieldValue = (isset($field->file['name_org'])) ? $field->file['name_org'] : '';
                        }
                        break;
                }
            }
            // process db value according to field type and field options with visformsPlaceholder Classes
            else {
                if (isset($field->dbValue)) {
                    $placeholder = VisfieldPlaceholderEntry::getInstance('', $field->dbValue, $field->typefield, $field);
                    $fieldValue = $placeholder->getReplaceValue();
                }
                else {
                    // fallback set to ""
                    $fieldValue = "";
                }
            }
            // stop execution for this field if the field value is empty and form option is set to hide empty fields in data included in mail
            switch ($type) {
                case 'admin' :
                    if (!empty($visform->emailresulthideemptyfields)) {
                        if (($field->typefield !== 'calculation') && ($fieldValue === '')) {
                            continue 2;
                        }
                        if (($field->typefield === 'calculation') && (!empty($visform->emailresultemptycaliszero)) && (VisformsHelper::checkNumberValueIsZero($fieldValue))) {
                            continue 2;
                        }
                    }
                    break;
                default :
                    if (!empty($visform->emailreceipthideemptyfields)) {
                        if (($field->typefield !== 'calculation') && ($fieldValue === '')) {
                            continue 2;
                        }
                        if (($field->typefield === 'calculation') && (!empty($visform->emailreceiptemptycaliszero)) && (VisformsHelper::checkNumberValueIsZero($fieldValue))) {
                            continue 2;
                        }
                    }
                    break;
            }
            if (($type == 'admin') && (!empty($visform->receiptmailaslink)) && ($field->typefield == 'email')) {
                $fieldValue = '<a href="mailto:' . $fieldValue . '">' . $fieldValue . '</a>';
            }
            $data[] = $label . " : " . $fieldValue;
        }
        return implode("<br />", $data);
    }
}