<?php
/**
 * VisformsSaveJFormExtraData Event for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 5.0.0
 */

namespace Visolutions\Component\Visforms\Administrator\Event\Visforms;
// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class VisfieldSaveJFormExtraDataEvent extends VisformsAbstractEvent{

    public function __construct($name, array $arguments = []) {
        parent::__construct($name, $arguments);

        if (!\array_key_exists('subject', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'subject' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('id', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'fid' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('isNew', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'isNew' of event {$name} is required but has not been provided");
        }
    }

    public function getData(): array  {
        return $this->arguments['subject'];
    }

    public function getIsNew(): bool {
        return $this->arguments['isNew'];
    }

    public function getId(): int {
        return $this->arguments['id'];
    }

}