<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class TextareaEntry extends VisfieldPlaceholderEntry {

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_DIE'
    );

	public function getReplaceValue() {
        $customParams =  array_merge(self::$labelParams, self::$customSubscriptionParams);
        if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
            switch ($this->param) {
                case 'DISPLAYLABEL' :
                    return $this->field->label;
                case 'DISPLAYLABELPLUSSPACE' :
                    return $this->field->label . ' ';
                case 'DIE' :
                    if ($this->rawData === '' && $this->hasSub) {
                        return 'die';
                    }
                    return '';
                default:
                    return '';
            }
        }
        else {
            if (!empty($this->field->keepBr)) {
                return HTMLHelper::_('visforms.replaceLinebreaks', $this->rawData, "<br />");
            }
            else {
                return HTMLHelper::_('visforms.replaceLinebreaks', $this->rawData, " ");
            }
        }
	}

}