<?php
/**
 * Visforms control html for radio for bootstrap default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Layout\LayoutHelper;

if (!empty($displayData)) :
    if (isset($displayData['field'])) :
        // we wrap the control in a div if the field isCondtional, so that we can easily hide the whole control
        // the div class=control is part of the control because it's position divers, depending on the field type
        $field = $displayData['field'];
        $clabel = $field->clabel;
        $ccustomtext = $field->ccustomtext;
        $inverseBtLabelClasses = $field->ctrlGroupBtClasses;
        $bt_size = $field->fieldGroupBootstrapClasses;
        $html = array();
        $html[] = '<div class="' . $bt_size . ' ';
        $html[] = (isset($field->isConditional) && ($field->isConditional == true)) ? 'conditional field' . $field->id : 'field' . $field->id;
        $html[] = (isset($field->attribute_required)) ? ' required' : '';
        $html[] = (isset($field->isDisabled) && ($field->isDisabled == true)) ? ' vishidden' : '';
        // closing quote for class attribute
        $html[] = '"';
        $html[] = ' role="radiogroup"';
        $html[] = (isset($field->{'attribute_aria-readonly'}) && ($field->{'attribute_aria-readonly'} === 'true')) ?  ' aria-readonly="true"'  : '';
        $html[] = ' aria-labelledby="' . $field->name. 'lbl"';
        $html[] = '>';
        if (($ccustomtext != '') && (isset($field->customtextposition)) && ($field->customtextposition == 0)) {
            $html[] = '<div class="row">';
            $html[] = $ccustomtext;
            $html[] = '</div>';
        }
        $html[] = '<div class="form-group row">';
        $html[] = $clabel;
        if (($ccustomtext != '') && (isset($field->customtextposition)) && ($field->customtextposition == 1)) {
            $html[] = '<div class="row">';
            $html[] = $ccustomtext;
            $html[] = '</div>';
        }
        $html[] = '<div class="' . $inverseBtLabelClasses . '">';
        $k = count($field->opts);
        $checked = "";
        $inputAttributes = (!empty($field->attributeArray)) ? ArrayHelper::toString($field->attributeArray, '=', ' ', true) : '';
        $asList = (isset($field->display) && $field->display == 'LST') ? true : false;
        for ($j = 0; $j < $k; $j++) {
            // option specific label class
            $labelClass = (!empty($field->opts[$j]['labelclass'])) ? $field->opts[$j]['labelclass'] . ' ' : '';
            $labelClass .= (!empty($asList)) ? '' : 'form-check-label';
            if ($field->opts[$j]['selected'] != false) {
                $checked = 'checked="checked" ';
            } else {
                $checked = "";
            }
            if (!empty($field->opts[$j]['disabled'])) {
                $disabled = ' disabled="disabled" data-disabled="disabled" ';
            } else {
                $disabled = "";
            }
            $html[] = '<div class="form-check' . ((empty($asList)) ? ' form-check-inline' : '') . '">';

            $html[] = '<input id="field' . $field->id . '_' . $j . '" name="' . $field->name . '" value="' . $field->opts[$j]['value'] . '" ' . $checked . $disabled . $inputAttributes . ' aria-labelledby="' . $field->name . 'lbl_' . $j . '" data-error-container-id="fc-tbxfield' . $field->id . '" />';
            $html[] = '<label class="' . $labelClass . ' ' . $field->labelCSSclass . '" id="' . $field->name . 'lbl_' . $j . '" for="field' . $field->id . '_' . $j . '">';
            $html[] = $field->opts[$j]['label'] . '</label>';
            $html[] = '</div>';
        }
        $html[] = '</div>';
        $html[] = '</div>';
        $html[] = '<div class="row"><div class="' . $inverseBtLabelClasses . '">';
        $html[] = LayoutHelper::render('visforms.custom.default_error_div', $displayData, null, array('component' => 'com_visforms'));
        $html[] = '</div>';
        $html[] = '</div>';
        if (($ccustomtext != '') && (((isset($field->customtextposition)) && ($field->customtextposition == 2)) || !(isset($field->customtextposition)))) {
            $html[] = '<div class="row">';
            $html[] = $ccustomtext;
            $html[] = '</div>';
        }

        $html[] = '</div>';
        echo implode('', $html);
    endif;
endif;