<?php
/**
 * Visforms captcha html for default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\HTML\HTMLHelper;

if (!empty($displayData)) :
	if (isset($displayData['form'])) :
		$form = $displayData['form'];
		$context = (isset($form->context)) ? $form->context : '';
		$name = $context . 'viscaptcha_response';
		$errorDivClass = 'fc-tbx' . $name . '_field';
		$html = array();
        if (isset($form->captcha) && (int) $form->captcha === 1) {
			$tooltip = (!empty($form->captchacustominfo)) ? ' title="'. htmlspecialchars($form->captchacustominfo, ENT_COMPAT, 'UTF-8') .'" data-bs-toogle' : '';
			$html[] = '<div class="captchaCont required">';
			// Create a div with the right class where we can put the validation errors into
			$html[] = '<div class="' . $errorDivClass . '"></div>';
            $html[] = LayoutHelper::render('visforms.captcha.default.label', array('form' => $form, 'name' => $name, 'htmlTag' => 'label'), null, array('component' => 'com_visforms'));
            $html[] = LayoutHelper::render('visforms.captcha.viscaptchaimg', array('form' => $form), null, array('component' => 'com_visforms'));
            $html[] = LayoutHelper::render('visforms.captcha.viscaptcharefresh', array('form' => $form), null, array('component' => 'com_visforms'));
            $html[] = '<input class="visCSStop10' . (!empty($form->preventsubmitonenter) ? " noEnterSubmit" : "") . ((!empty($form->captchacustominfo)) ? " visToolTip" : "") . '" type="text" id="' . $name . '" name="' . $name . '" data-error-container-id="' . $errorDivClass . '" required="required"'.$tooltip.' />';

			if (!empty($form->captchacustominfo)) {
				HTMLHelper::_('visforms.visformsTooltip');
			}
			$html[] = '</div>';
		}
		echo implode('', $html);
	endif;
endif;

        